/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;

public class ListDistributionsIterable
implements SdkIterable<ListDistributionsResponse> {
    private final CloudFrontClient client;
    private final ListDistributionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDistributionsIterable(CloudFrontClient client, ListDistributionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDistributionsResponseFetcher();
    }

    public Iterator<ListDistributionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DistributionSummary> items() {
        Function<ListDistributionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionList() != null && response.distributionList().items() != null) {
                return response.distributionList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDistributionsResponseFetcher
    implements SyncPageFetcher<ListDistributionsResponse> {
        private ListDistributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsResponse previousPage) {
            return previousPage.distributionList().isTruncated();
        }

        public ListDistributionsResponse nextPage(ListDistributionsResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsIterable.this.client.listDistributions(ListDistributionsIterable.this.firstRequest);
            }
            return ListDistributionsIterable.this.client.listDistributions((ListDistributionsRequest)((Object)ListDistributionsIterable.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

