/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.ContentTypeProfile;
import software.amazon.awssdk.services.cloudfront.model.ContentTypeProfileListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentTypeProfiles
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentTypeProfiles> {
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(ContentTypeProfiles.getter(ContentTypeProfiles::quantity)).setter(ContentTypeProfiles.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final SdkField<List<ContentTypeProfile>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(ContentTypeProfiles.getter(ContentTypeProfiles::items)).setter(ContentTypeProfiles.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("ContentTypeProfile").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContentTypeProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypeProfile").unmarshallLocationName("ContentTypeProfile").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTITY_FIELD, ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer quantity;
    private final List<ContentTypeProfile> items;

    private ContentTypeProfiles(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<ContentTypeProfile> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentTypeProfiles)) {
            return false;
        }
        ContentTypeProfiles other = (ContentTypeProfiles)obj;
        return Objects.equals(this.quantity(), other.quantity()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"ContentTypeProfiles").add("Quantity", (Object)this.quantity()).add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentTypeProfiles, T> g) {
        return obj -> g.apply((ContentTypeProfiles)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<ContentTypeProfile> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentTypeProfiles model) {
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        @Transient
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<ContentTypeProfile.Builder> getItems() {
            List<ContentTypeProfile.Builder> result = ContentTypeProfileListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ContentTypeProfile.BuilderImpl> items) {
            this.items = ContentTypeProfileListCopier.copyFromBuilder(items);
        }

        @Override
        @Transient
        public final Builder items(Collection<ContentTypeProfile> items) {
            this.items = ContentTypeProfileListCopier.copy(items);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(ContentTypeProfile ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder items(Consumer<ContentTypeProfile.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ContentTypeProfile)((ContentTypeProfile.Builder)ContentTypeProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContentTypeProfiles build() {
            return new ContentTypeProfiles(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentTypeProfiles> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<ContentTypeProfile> var1);

        public Builder items(ContentTypeProfile ... var1);

        public Builder items(Consumer<ContentTypeProfile.Builder> ... var1);
    }
}

