/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.FunctionList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFunctionsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListFunctionsResponse> {
    private static final SdkField<FunctionList> FUNCTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunctionList").getter(ListFunctionsResponse.getter(ListFunctionsResponse::functionList)).setter(ListFunctionsResponse.setter(Builder::functionList)).constructor(FunctionList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionList").unmarshallLocationName("FunctionList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_LIST_FIELD));
    private final FunctionList functionList;

    private ListFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.functionList = builder.functionList;
    }

    public final FunctionList functionList() {
        return this.functionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsResponse)) {
            return false;
        }
        ListFunctionsResponse other = (ListFunctionsResponse)((Object)obj);
        return Objects.equals(this.functionList(), other.functionList());
    }

    public final String toString() {
        return ToString.builder((String)"ListFunctionsResponse").add("FunctionList", (Object)this.functionList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionList": {
                return Optional.ofNullable(clazz.cast(this.functionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionsResponse, T> g) {
        return obj -> g.apply((ListFunctionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private FunctionList functionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsResponse model) {
            super(model);
            this.functionList(model.functionList);
        }

        public final FunctionList.Builder getFunctionList() {
            return this.functionList != null ? this.functionList.toBuilder() : null;
        }

        public final void setFunctionList(FunctionList.BuilderImpl functionList) {
            this.functionList = functionList != null ? functionList.build() : null;
        }

        @Override
        @Transient
        public final Builder functionList(FunctionList functionList) {
            this.functionList = functionList;
            return this;
        }

        @Override
        public ListFunctionsResponse build() {
            return new ListFunctionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFunctionsResponse> {
        public Builder functionList(FunctionList var1);

        default public Builder functionList(Consumer<FunctionList.Builder> functionList) {
            return this.functionList((FunctionList)((FunctionList.Builder)FunctionList.builder().applyMutation(functionList)).build());
        }
    }
}

