/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.TestResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestFunctionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, TestFunctionResponse> {
    private static final SdkField<TestResult> TEST_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TestResult").getter(TestFunctionResponse.getter(TestFunctionResponse::testResult)).setter(TestFunctionResponse.setter(Builder::testResult)).constructor(TestResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestResult").unmarshallLocationName("TestResult").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_RESULT_FIELD));
    private final TestResult testResult;

    private TestFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.testResult = builder.testResult;
    }

    public final TestResult testResult() {
        return this.testResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestFunctionResponse)) {
            return false;
        }
        TestFunctionResponse other = (TestFunctionResponse)((Object)obj);
        return Objects.equals(this.testResult(), other.testResult());
    }

    public final String toString() {
        return ToString.builder((String)"TestFunctionResponse").add("TestResult", (Object)this.testResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TestResult": {
                return Optional.ofNullable(clazz.cast(this.testResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestFunctionResponse, T> g) {
        return obj -> g.apply((TestFunctionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private TestResult testResult;

        private BuilderImpl() {
        }

        private BuilderImpl(TestFunctionResponse model) {
            super(model);
            this.testResult(model.testResult);
        }

        public final TestResult.Builder getTestResult() {
            return this.testResult != null ? this.testResult.toBuilder() : null;
        }

        @Override
        public final Builder testResult(TestResult testResult) {
            this.testResult = testResult;
            return this;
        }

        public final void setTestResult(TestResult.BuilderImpl testResult) {
            this.testResult = testResult != null ? testResult.build() : null;
        }

        @Override
        public TestFunctionResponse build() {
            return new TestFunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestFunctionResponse> {
        public Builder testResult(TestResult var1);

        default public Builder testResult(Consumer<TestResult.Builder> testResult) {
            return this.testResult((TestResult)((TestResult.Builder)TestResult.builder().applyMutation(testResult)).build());
        }
    }
}

