/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.FunctionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFunctionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateFunctionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateFunctionRequest.getter(UpdateFunctionRequest::name)).setter(UpdateFunctionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(UpdateFunctionRequest.getter(UpdateFunctionRequest::ifMatch)).setter(UpdateFunctionRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final SdkField<FunctionConfig> FUNCTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FunctionConfig").getter(UpdateFunctionRequest.getter(UpdateFunctionRequest::functionConfig)).setter(UpdateFunctionRequest.setter(Builder::functionConfig)).constructor(FunctionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionConfig").unmarshallLocationName("FunctionConfig").build()}).build();
    private static final SdkField<SdkBytes> FUNCTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("FunctionCode").getter(UpdateFunctionRequest.getter(UpdateFunctionRequest::functionCode)).setter(UpdateFunctionRequest.setter(Builder::functionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionCode").unmarshallLocationName("FunctionCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IF_MATCH_FIELD, FUNCTION_CONFIG_FIELD, FUNCTION_CODE_FIELD));
    private final String name;
    private final String ifMatch;
    private final FunctionConfig functionConfig;
    private final SdkBytes functionCode;

    private UpdateFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ifMatch = builder.ifMatch;
        this.functionConfig = builder.functionConfig;
        this.functionCode = builder.functionCode;
    }

    public final String name() {
        return this.name;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final FunctionConfig functionConfig() {
        return this.functionConfig;
    }

    public final SdkBytes functionCode() {
        return this.functionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionRequest)) {
            return false;
        }
        UpdateFunctionRequest other = (UpdateFunctionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ifMatch(), other.ifMatch()) && Objects.equals(this.functionConfig(), other.functionConfig()) && Objects.equals(this.functionCode(), other.functionCode());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFunctionRequest").add("Name", (Object)this.name()).add("IfMatch", (Object)this.ifMatch()).add("FunctionConfig", (Object)this.functionConfig()).add("FunctionCode", (Object)(this.functionCode() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "FunctionConfig": {
                return Optional.ofNullable(clazz.cast(this.functionConfig()));
            }
            case "FunctionCode": {
                return Optional.ofNullable(clazz.cast(this.functionCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionRequest, T> g) {
        return obj -> g.apply((UpdateFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String name;
        private String ifMatch;
        private FunctionConfig functionConfig;
        private SdkBytes functionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionRequest model) {
            super(model);
            this.name(model.name);
            this.ifMatch(model.ifMatch);
            this.functionConfig(model.functionConfig);
            this.functionCode(model.functionCode);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        public final FunctionConfig.Builder getFunctionConfig() {
            return this.functionConfig != null ? this.functionConfig.toBuilder() : null;
        }

        @Override
        public final Builder functionConfig(FunctionConfig functionConfig) {
            this.functionConfig = functionConfig;
            return this;
        }

        public final void setFunctionConfig(FunctionConfig.BuilderImpl functionConfig) {
            this.functionConfig = functionConfig != null ? functionConfig.build() : null;
        }

        public final ByteBuffer getFunctionCode() {
            return this.functionCode == null ? null : this.functionCode.asByteBuffer();
        }

        @Override
        public final Builder functionCode(SdkBytes functionCode) {
            this.functionCode = functionCode;
            return this;
        }

        public final void setFunctionCode(ByteBuffer functionCode) {
            this.functionCode(functionCode == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)functionCode));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionRequest build() {
            return new UpdateFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFunctionRequest> {
        public Builder name(String var1);

        public Builder ifMatch(String var1);

        public Builder functionConfig(FunctionConfig var1);

        default public Builder functionConfig(Consumer<FunctionConfig.Builder> functionConfig) {
            return this.functionConfig((FunctionConfig)((FunctionConfig.Builder)FunctionConfig.builder().applyMutation(functionConfig)).build());
        }

        public Builder functionCode(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

