/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfig;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealtimeLogConfigs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealtimeLogConfigs> {
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(RealtimeLogConfigs.getter(RealtimeLogConfigs::maxItems)).setter(RealtimeLogConfigs.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<List<RealtimeLogConfig>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(RealtimeLogConfigs.getter(RealtimeLogConfigs::items)).setter(RealtimeLogConfigs.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RealtimeLogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(RealtimeLogConfigs.getter(RealtimeLogConfigs::isTruncated)).setter(RealtimeLogConfigs.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(RealtimeLogConfigs.getter(RealtimeLogConfigs::marker)).setter(RealtimeLogConfigs.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").unmarshallLocationName("Marker").build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(RealtimeLogConfigs.getter(RealtimeLogConfigs::nextMarker)).setter(RealtimeLogConfigs.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ITEMS_FIELD, ITEMS_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD, NEXT_MARKER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxItems;
    private final List<RealtimeLogConfig> items;
    private final Boolean isTruncated;
    private final String marker;
    private final String nextMarker;

    private RealtimeLogConfigs(BuilderImpl builder) {
        this.maxItems = builder.maxItems;
        this.items = builder.items;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<RealtimeLogConfig> items() {
        return this.items;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeLogConfigs)) {
            return false;
        }
        RealtimeLogConfigs other = (RealtimeLogConfigs)obj;
        return Objects.equals(this.maxItems(), other.maxItems()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"RealtimeLogConfigs").add("MaxItems", (Object)this.maxItems()).add("Items", this.hasItems() ? this.items() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealtimeLogConfigs, T> g) {
        return obj -> g.apply((RealtimeLogConfigs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxItems;
        private List<RealtimeLogConfig> items = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeLogConfigs model) {
            this.maxItems(model.maxItems);
            this.items(model.items);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
            this.nextMarker(model.nextMarker);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final List<RealtimeLogConfig.Builder> getItems() {
            List<RealtimeLogConfig.Builder> result = RealtimeLogConfigListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder items(Collection<RealtimeLogConfig> items) {
            this.items = RealtimeLogConfigListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RealtimeLogConfig ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RealtimeLogConfig.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (RealtimeLogConfig)((RealtimeLogConfig.Builder)RealtimeLogConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<RealtimeLogConfig.BuilderImpl> items) {
            this.items = RealtimeLogConfigListCopier.copyFromBuilder(items);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public RealtimeLogConfigs build() {
            return new RealtimeLogConfigs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealtimeLogConfigs> {
        public Builder maxItems(Integer var1);

        public Builder items(Collection<RealtimeLogConfig> var1);

        public Builder items(RealtimeLogConfig ... var1);

        public Builder items(Consumer<RealtimeLogConfig.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);

        public Builder nextMarker(String var1);
    }
}

