/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType;
import software.amazon.awssdk.services.cloudfront.model.LocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoRestriction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoRestriction> {
    private static final SdkField<String> RESTRICTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestrictionType").getter(GeoRestriction.getter(GeoRestriction::restrictionTypeAsString)).setter(GeoRestriction.setter(Builder::restrictionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictionType").unmarshallLocationName("RestrictionType").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(GeoRestriction.getter(GeoRestriction::quantity)).setter(GeoRestriction.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final SdkField<List<String>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(GeoRestriction.getter(GeoRestriction::items)).setter(GeoRestriction.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("Location").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").unmarshallLocationName("Location").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTRICTION_TYPE_FIELD, QUANTITY_FIELD, ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String restrictionType;
    private final Integer quantity;
    private final List<String> items;

    private GeoRestriction(BuilderImpl builder) {
        this.restrictionType = builder.restrictionType;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public final GeoRestrictionType restrictionType() {
        return GeoRestrictionType.fromValue(this.restrictionType);
    }

    public final String restrictionTypeAsString() {
        return this.restrictionType;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<String> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoRestriction)) {
            return false;
        }
        GeoRestriction other = (GeoRestriction)obj;
        return Objects.equals(this.restrictionTypeAsString(), other.restrictionTypeAsString()) && Objects.equals(this.quantity(), other.quantity()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"GeoRestriction").add("RestrictionType", (Object)this.restrictionTypeAsString()).add("Quantity", (Object)this.quantity()).add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestrictionType": {
                return Optional.ofNullable(clazz.cast(this.restrictionTypeAsString()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoRestriction, T> g) {
        return obj -> g.apply((GeoRestriction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String restrictionType;
        private Integer quantity;
        private List<String> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeoRestriction model) {
            this.restrictionType(model.restrictionType);
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final String getRestrictionType() {
            return this.restrictionType;
        }

        @Override
        public final Builder restrictionType(String restrictionType) {
            this.restrictionType = restrictionType;
            return this;
        }

        @Override
        public final Builder restrictionType(GeoRestrictionType restrictionType) {
            this.restrictionType(restrictionType == null ? null : restrictionType.toString());
            return this;
        }

        public final void setRestrictionType(String restrictionType) {
            this.restrictionType = restrictionType;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            if (this.items instanceof SdkAutoConstructList) {
                return null;
            }
            return this.items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = LocationListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = LocationListCopier.copy(items);
        }

        public GeoRestriction build() {
            return new GeoRestriction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoRestriction> {
        public Builder restrictionType(String var1);

        public Builder restrictionType(GeoRestrictionType var1);

        public Builder quantity(Integer var1);

        public Builder items(Collection<String> var1);

        public Builder items(String ... var1);
    }
}

