/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistribution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamingDistributionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetStreamingDistributionResponse> {
    private static final SdkField<StreamingDistribution> STREAMING_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingDistribution").getter(GetStreamingDistributionResponse.getter(GetStreamingDistributionResponse::streamingDistribution)).setter(GetStreamingDistributionResponse.setter(Builder::streamingDistribution)).constructor(StreamingDistribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistribution").unmarshallLocationName("StreamingDistribution").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetStreamingDistributionResponse.getter(GetStreamingDistributionResponse::eTag)).setter(GetStreamingDistributionResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_DISTRIBUTION_FIELD, E_TAG_FIELD));
    private final StreamingDistribution streamingDistribution;
    private final String eTag;

    private GetStreamingDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistribution = builder.streamingDistribution;
        this.eTag = builder.eTag;
    }

    public final StreamingDistribution streamingDistribution() {
        return this.streamingDistribution;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamingDistributionResponse)) {
            return false;
        }
        GetStreamingDistributionResponse other = (GetStreamingDistributionResponse)((Object)obj);
        return Objects.equals(this.streamingDistribution(), other.streamingDistribution()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetStreamingDistributionResponse").add("StreamingDistribution", (Object)this.streamingDistribution()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingDistribution": {
                return Optional.ofNullable(clazz.cast(this.streamingDistribution()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStreamingDistributionResponse, T> g) {
        return obj -> g.apply((GetStreamingDistributionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private StreamingDistribution streamingDistribution;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamingDistributionResponse model) {
            super(model);
            this.streamingDistribution(model.streamingDistribution);
            this.eTag(model.eTag);
        }

        public final StreamingDistribution.Builder getStreamingDistribution() {
            return this.streamingDistribution != null ? this.streamingDistribution.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
            return this;
        }

        public final void setStreamingDistribution(StreamingDistribution.BuilderImpl streamingDistribution) {
            this.streamingDistribution = streamingDistribution != null ? streamingDistribution.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetStreamingDistributionResponse build() {
            return new GetStreamingDistributionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamingDistributionResponse> {
        public Builder streamingDistribution(StreamingDistribution var1);

        default public Builder streamingDistribution(Consumer<StreamingDistribution.Builder> streamingDistribution) {
            return this.streamingDistribution((StreamingDistribution)((StreamingDistribution.Builder)StreamingDistribution.builder().applyMutation(streamingDistribution)).build());
        }

        public Builder eTag(String var1);
    }
}

