/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader;
import software.amazon.awssdk.services.cloudfront.model.OriginCustomHeadersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomHeaders
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomHeaders> {
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(CustomHeaders.getter(CustomHeaders::quantity)).setter(CustomHeaders.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final SdkField<List<OriginCustomHeader>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(CustomHeaders.getter(CustomHeaders::items)).setter(CustomHeaders.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("OriginCustomHeader").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OriginCustomHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginCustomHeader").unmarshallLocationName("OriginCustomHeader").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTITY_FIELD, ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer quantity;
    private final List<OriginCustomHeader> items;

    private CustomHeaders(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public List<OriginCustomHeader> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomHeaders)) {
            return false;
        }
        CustomHeaders other = (CustomHeaders)obj;
        return Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"CustomHeaders").add("Quantity", (Object)this.quantity()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomHeaders, T> g) {
        return obj -> g.apply((CustomHeaders)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<OriginCustomHeader> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomHeaders model) {
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<OriginCustomHeader.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(OriginCustomHeader::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<OriginCustomHeader> items) {
            this.items = OriginCustomHeadersListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(OriginCustomHeader ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<OriginCustomHeader.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (OriginCustomHeader)((OriginCustomHeader.Builder)OriginCustomHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<OriginCustomHeader.BuilderImpl> items) {
            this.items = OriginCustomHeadersListCopier.copyFromBuilder(items);
        }

        public CustomHeaders build() {
            return new CustomHeaders(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomHeaders> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<OriginCustomHeader> var1);

        public Builder items(OriginCustomHeader ... var1);

        public Builder items(Consumer<OriginCustomHeader.Builder> ... var1);
    }
}

