/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionsByRealtimeLogConfigRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, ListDistributionsByRealtimeLogConfigRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListDistributionsByRealtimeLogConfigRequest.getter(ListDistributionsByRealtimeLogConfigRequest::marker)).setter(ListDistributionsByRealtimeLogConfigRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").unmarshallLocationName("Marker").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListDistributionsByRealtimeLogConfigRequest.getter(ListDistributionsByRealtimeLogConfigRequest::maxItems)).setter(ListDistributionsByRealtimeLogConfigRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<String> REALTIME_LOG_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RealtimeLogConfigName").getter(ListDistributionsByRealtimeLogConfigRequest.getter(ListDistributionsByRealtimeLogConfigRequest::realtimeLogConfigName)).setter(ListDistributionsByRealtimeLogConfigRequest.setter(Builder::realtimeLogConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfigName").unmarshallLocationName("RealtimeLogConfigName").build()}).build();
    private static final SdkField<String> REALTIME_LOG_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RealtimeLogConfigArn").getter(ListDistributionsByRealtimeLogConfigRequest.getter(ListDistributionsByRealtimeLogConfigRequest::realtimeLogConfigArn)).setter(ListDistributionsByRealtimeLogConfigRequest.setter(Builder::realtimeLogConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfigArn").unmarshallLocationName("RealtimeLogConfigArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD, REALTIME_LOG_CONFIG_NAME_FIELD, REALTIME_LOG_CONFIG_ARN_FIELD));
    private final String marker;
    private final String maxItems;
    private final String realtimeLogConfigName;
    private final String realtimeLogConfigArn;

    private ListDistributionsByRealtimeLogConfigRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.realtimeLogConfigName = builder.realtimeLogConfigName;
        this.realtimeLogConfigArn = builder.realtimeLogConfigArn;
    }

    public String marker() {
        return this.marker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public String realtimeLogConfigName() {
        return this.realtimeLogConfigName;
    }

    public String realtimeLogConfigArn() {
        return this.realtimeLogConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.realtimeLogConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.realtimeLogConfigArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByRealtimeLogConfigRequest)) {
            return false;
        }
        ListDistributionsByRealtimeLogConfigRequest other = (ListDistributionsByRealtimeLogConfigRequest)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.realtimeLogConfigName(), other.realtimeLogConfigName()) && Objects.equals(this.realtimeLogConfigArn(), other.realtimeLogConfigArn());
    }

    public String toString() {
        return ToString.builder((String)"ListDistributionsByRealtimeLogConfigRequest").add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).add("RealtimeLogConfigName", (Object)this.realtimeLogConfigName()).add("RealtimeLogConfigArn", (Object)this.realtimeLogConfigArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "RealtimeLogConfigName": {
                return Optional.ofNullable(clazz.cast(this.realtimeLogConfigName()));
            }
            case "RealtimeLogConfigArn": {
                return Optional.ofNullable(clazz.cast(this.realtimeLogConfigArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByRealtimeLogConfigRequest, T> g) {
        return obj -> g.apply((ListDistributionsByRealtimeLogConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String marker;
        private String maxItems;
        private String realtimeLogConfigName;
        private String realtimeLogConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByRealtimeLogConfigRequest model) {
            super(model);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
            this.realtimeLogConfigName(model.realtimeLogConfigName);
            this.realtimeLogConfigArn(model.realtimeLogConfigArn);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public final String getRealtimeLogConfigName() {
            return this.realtimeLogConfigName;
        }

        @Override
        public final Builder realtimeLogConfigName(String realtimeLogConfigName) {
            this.realtimeLogConfigName = realtimeLogConfigName;
            return this;
        }

        public final void setRealtimeLogConfigName(String realtimeLogConfigName) {
            this.realtimeLogConfigName = realtimeLogConfigName;
        }

        public final String getRealtimeLogConfigArn() {
            return this.realtimeLogConfigArn;
        }

        @Override
        public final Builder realtimeLogConfigArn(String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
            return this;
        }

        public final void setRealtimeLogConfigArn(String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByRealtimeLogConfigRequest build() {
            return new ListDistributionsByRealtimeLogConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDistributionsByRealtimeLogConfigRequest> {
        public Builder marker(String var1);

        public Builder maxItems(String var1);

        public Builder realtimeLogConfigName(String var1);

        public Builder realtimeLogConfigArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

