/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.KeyGroupConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKeyGroupConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetKeyGroupConfigResponse> {
    private static final SdkField<KeyGroupConfig> KEY_GROUP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyGroupConfig").getter(GetKeyGroupConfigResponse.getter(GetKeyGroupConfigResponse::keyGroupConfig)).setter(GetKeyGroupConfigResponse.setter(Builder::keyGroupConfig)).constructor(KeyGroupConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyGroupConfig").unmarshallLocationName("KeyGroupConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetKeyGroupConfigResponse.getter(GetKeyGroupConfigResponse::eTag)).setter(GetKeyGroupConfigResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_GROUP_CONFIG_FIELD, E_TAG_FIELD));
    private final KeyGroupConfig keyGroupConfig;
    private final String eTag;

    private GetKeyGroupConfigResponse(BuilderImpl builder) {
        super(builder);
        this.keyGroupConfig = builder.keyGroupConfig;
        this.eTag = builder.eTag;
    }

    public KeyGroupConfig keyGroupConfig() {
        return this.keyGroupConfig;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyGroupConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyGroupConfigResponse)) {
            return false;
        }
        GetKeyGroupConfigResponse other = (GetKeyGroupConfigResponse)((Object)obj);
        return Objects.equals(this.keyGroupConfig(), other.keyGroupConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public String toString() {
        return ToString.builder((String)"GetKeyGroupConfigResponse").add("KeyGroupConfig", (Object)this.keyGroupConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyGroupConfig": {
                return Optional.ofNullable(clazz.cast(this.keyGroupConfig()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKeyGroupConfigResponse, T> g) {
        return obj -> g.apply((GetKeyGroupConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private KeyGroupConfig keyGroupConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyGroupConfigResponse model) {
            super(model);
            this.keyGroupConfig(model.keyGroupConfig);
            this.eTag(model.eTag);
        }

        public final KeyGroupConfig.Builder getKeyGroupConfig() {
            return this.keyGroupConfig != null ? this.keyGroupConfig.toBuilder() : null;
        }

        @Override
        public final Builder keyGroupConfig(KeyGroupConfig keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig;
            return this;
        }

        public final void setKeyGroupConfig(KeyGroupConfig.BuilderImpl keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig != null ? keyGroupConfig.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetKeyGroupConfigResponse build() {
            return new GetKeyGroupConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKeyGroupConfigResponse> {
        public Builder keyGroupConfig(KeyGroupConfig var1);

        default public Builder keyGroupConfig(Consumer<KeyGroupConfig.Builder> keyGroupConfig) {
            return this.keyGroupConfig((KeyGroupConfig)((KeyGroupConfig.Builder)KeyGroupConfig.builder().applyMutation(keyGroupConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

