/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.KeyGroupConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyGroup> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(KeyGroup.getter(KeyGroup::id)).setter(KeyGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(KeyGroup.getter(KeyGroup::lastModifiedTime)).setter(KeyGroup.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final SdkField<KeyGroupConfig> KEY_GROUP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyGroupConfig").getter(KeyGroup.getter(KeyGroup::keyGroupConfig)).setter(KeyGroup.setter(Builder::keyGroupConfig)).constructor(KeyGroupConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyGroupConfig").unmarshallLocationName("KeyGroupConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, LAST_MODIFIED_TIME_FIELD, KEY_GROUP_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant lastModifiedTime;
    private final KeyGroupConfig keyGroupConfig;

    private KeyGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.keyGroupConfig = builder.keyGroupConfig;
    }

    public String id() {
        return this.id;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public KeyGroupConfig keyGroupConfig() {
        return this.keyGroupConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyGroupConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyGroup)) {
            return false;
        }
        KeyGroup other = (KeyGroup)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.keyGroupConfig(), other.keyGroupConfig());
    }

    public String toString() {
        return ToString.builder((String)"KeyGroup").add("Id", (Object)this.id()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("KeyGroupConfig", (Object)this.keyGroupConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "KeyGroupConfig": {
                return Optional.ofNullable(clazz.cast(this.keyGroupConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyGroup, T> g) {
        return obj -> g.apply((KeyGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant lastModifiedTime;
        private KeyGroupConfig keyGroupConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyGroup model) {
            this.id(model.id);
            this.lastModifiedTime(model.lastModifiedTime);
            this.keyGroupConfig(model.keyGroupConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final KeyGroupConfig.Builder getKeyGroupConfig() {
            return this.keyGroupConfig != null ? this.keyGroupConfig.toBuilder() : null;
        }

        @Override
        public final Builder keyGroupConfig(KeyGroupConfig keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig;
            return this;
        }

        public final void setKeyGroupConfig(KeyGroupConfig.BuilderImpl keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig != null ? keyGroupConfig.build() : null;
        }

        public KeyGroup build() {
            return new KeyGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyGroup> {
        public Builder id(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder keyGroupConfig(KeyGroupConfig var1);

        default public Builder keyGroupConfig(Consumer<KeyGroupConfig.Builder> keyGroupConfig) {
            return this.keyGroupConfig((KeyGroupConfig)((KeyGroupConfig.Builder)KeyGroupConfig.builder().applyMutation(keyGroupConfig)).build());
        }
    }
}

