/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomErrorResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomErrorResponse> {
    private static final SdkField<Integer> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ErrorCode").getter(CustomErrorResponse.getter(CustomErrorResponse::errorCode)).setter(CustomErrorResponse.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").unmarshallLocationName("ErrorCode").build()}).build();
    private static final SdkField<String> RESPONSE_PAGE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResponsePagePath").getter(CustomErrorResponse.getter(CustomErrorResponse::responsePagePath)).setter(CustomErrorResponse.setter(Builder::responsePagePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponsePagePath").unmarshallLocationName("ResponsePagePath").build()}).build();
    private static final SdkField<String> RESPONSE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResponseCode").getter(CustomErrorResponse.getter(CustomErrorResponse::responseCode)).setter(CustomErrorResponse.setter(Builder::responseCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").unmarshallLocationName("ResponseCode").build()}).build();
    private static final SdkField<Long> ERROR_CACHING_MIN_TTL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ErrorCachingMinTTL").getter(CustomErrorResponse.getter(CustomErrorResponse::errorCachingMinTTL)).setter(CustomErrorResponse.setter(Builder::errorCachingMinTTL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCachingMinTTL").unmarshallLocationName("ErrorCachingMinTTL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, RESPONSE_PAGE_PATH_FIELD, RESPONSE_CODE_FIELD, ERROR_CACHING_MIN_TTL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer errorCode;
    private final String responsePagePath;
    private final String responseCode;
    private final Long errorCachingMinTTL;

    private CustomErrorResponse(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.responsePagePath = builder.responsePagePath;
        this.responseCode = builder.responseCode;
        this.errorCachingMinTTL = builder.errorCachingMinTTL;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    public String responsePagePath() {
        return this.responsePagePath;
    }

    public String responseCode() {
        return this.responseCode;
    }

    public Long errorCachingMinTTL() {
        return this.errorCachingMinTTL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responsePagePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCachingMinTTL());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomErrorResponse)) {
            return false;
        }
        CustomErrorResponse other = (CustomErrorResponse)obj;
        return Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.responsePagePath(), other.responsePagePath()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.errorCachingMinTTL(), other.errorCachingMinTTL());
    }

    public String toString() {
        return ToString.builder((String)"CustomErrorResponse").add("ErrorCode", (Object)this.errorCode()).add("ResponsePagePath", (Object)this.responsePagePath()).add("ResponseCode", (Object)this.responseCode()).add("ErrorCachingMinTTL", (Object)this.errorCachingMinTTL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ResponsePagePath": {
                return Optional.ofNullable(clazz.cast(this.responsePagePath()));
            }
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "ErrorCachingMinTTL": {
                return Optional.ofNullable(clazz.cast(this.errorCachingMinTTL()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomErrorResponse, T> g) {
        return obj -> g.apply((CustomErrorResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer errorCode;
        private String responsePagePath;
        private String responseCode;
        private Long errorCachingMinTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomErrorResponse model) {
            this.errorCode(model.errorCode);
            this.responsePagePath(model.responsePagePath);
            this.responseCode(model.responseCode);
            this.errorCachingMinTTL(model.errorCachingMinTTL);
        }

        public final Integer getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public final String getResponsePagePath() {
            return this.responsePagePath;
        }

        @Override
        public final Builder responsePagePath(String responsePagePath) {
            this.responsePagePath = responsePagePath;
            return this;
        }

        public final void setResponsePagePath(String responsePagePath) {
            this.responsePagePath = responsePagePath;
        }

        public final String getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final Long getErrorCachingMinTTL() {
            return this.errorCachingMinTTL;
        }

        @Override
        public final Builder errorCachingMinTTL(Long errorCachingMinTTL) {
            this.errorCachingMinTTL = errorCachingMinTTL;
            return this;
        }

        public final void setErrorCachingMinTTL(Long errorCachingMinTTL) {
            this.errorCachingMinTTL = errorCachingMinTTL;
        }

        public CustomErrorResponse build() {
            return new CustomErrorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomErrorResponse> {
        public Builder errorCode(Integer var1);

        public Builder responsePagePath(String var1);

        public Builder responseCode(String var1);

        public Builder errorCachingMinTTL(Long var1);
    }
}

