/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MinimumProtocolVersion {
    SSL_V3("SSLv3"),
    TLS_V1("TLSv1"),
    TLS_V1_2016("TLSv1_2016"),
    TLS_V1_1_2016("TLSv1.1_2016"),
    TLS_V1_2_2018("TLSv1.2_2018"),
    TLS_V1_2_2019("TLSv1.2_2019"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MinimumProtocolVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MinimumProtocolVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MinimumProtocolVersion.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MinimumProtocolVersion> knownValues() {
        return Stream.of(MinimumProtocolVersion.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

