/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCachePolicyConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetCachePolicyConfigResponse> {
    private static final SdkField<CachePolicyConfig> CACHE_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetCachePolicyConfigResponse.getter(GetCachePolicyConfigResponse::cachePolicyConfig)).setter(GetCachePolicyConfigResponse.setter(Builder::cachePolicyConfig)).constructor(CachePolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyConfig").unmarshallLocationName("CachePolicyConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCachePolicyConfigResponse.getter(GetCachePolicyConfigResponse::eTag)).setter(GetCachePolicyConfigResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_POLICY_CONFIG_FIELD, E_TAG_FIELD));
    private final CachePolicyConfig cachePolicyConfig;
    private final String eTag;

    private GetCachePolicyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.cachePolicyConfig = builder.cachePolicyConfig;
        this.eTag = builder.eTag;
    }

    public CachePolicyConfig cachePolicyConfig() {
        return this.cachePolicyConfig;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCachePolicyConfigResponse)) {
            return false;
        }
        GetCachePolicyConfigResponse other = (GetCachePolicyConfigResponse)((Object)obj);
        return Objects.equals(this.cachePolicyConfig(), other.cachePolicyConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public String toString() {
        return ToString.builder((String)"GetCachePolicyConfigResponse").add("CachePolicyConfig", (Object)this.cachePolicyConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CachePolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.cachePolicyConfig()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCachePolicyConfigResponse, T> g) {
        return obj -> g.apply((GetCachePolicyConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private CachePolicyConfig cachePolicyConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCachePolicyConfigResponse model) {
            super(model);
            this.cachePolicyConfig(model.cachePolicyConfig);
            this.eTag(model.eTag);
        }

        public final CachePolicyConfig.Builder getCachePolicyConfig() {
            return this.cachePolicyConfig != null ? this.cachePolicyConfig.toBuilder() : null;
        }

        @Override
        public final Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        public final void setCachePolicyConfig(CachePolicyConfig.BuilderImpl cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig != null ? cachePolicyConfig.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetCachePolicyConfigResponse build() {
            return new GetCachePolicyConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCachePolicyConfigResponse> {
        public Builder cachePolicyConfig(CachePolicyConfig var1);

        default public Builder cachePolicyConfig(Consumer<CachePolicyConfig.Builder> cachePolicyConfig) {
            return this.cachePolicyConfig((CachePolicyConfig)((CachePolicyConfig.Builder)CachePolicyConfig.builder().applyMutation(cachePolicyConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

