/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.S3Origin;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfigWithTags;
import software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig;
import software.amazon.awssdk.services.cloudfront.model.Tag;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;

public class CreateStreamingDistributionWithTagsRequestMarshaller
implements Marshaller<Request<CreateStreamingDistributionWithTagsRequest>, CreateStreamingDistributionWithTagsRequest> {
    public Request<CreateStreamingDistributionWithTagsRequest> marshall(CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) {
        if (createStreamingDistributionWithTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createStreamingDistributionWithTagsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2017-03-25/streaming-distribution?WithTags";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            StreamingDistributionConfigWithTags streamingDistributionConfigWithTags = createStreamingDistributionWithTagsRequest.streamingDistributionConfigWithTags();
            if (streamingDistributionConfigWithTags != null) {
                Tags tags;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("StreamingDistributionConfigWithTags");
                StreamingDistributionConfig streamingDistributionConfig = streamingDistributionConfigWithTags.streamingDistributionConfig();
                if (streamingDistributionConfig != null) {
                    TrustedSigners trustedSigners;
                    StreamingLoggingConfig logging;
                    Aliases aliases;
                    S3Origin s3Origin;
                    xmlWriter.startElement("StreamingDistributionConfig");
                    if (streamingDistributionConfig.callerReference() != null) {
                        xmlWriter.startElement("CallerReference").value(streamingDistributionConfig.callerReference()).endElement();
                    }
                    if ((s3Origin = streamingDistributionConfig.s3Origin()) != null) {
                        xmlWriter.startElement("S3Origin");
                        if (s3Origin.domainName() != null) {
                            xmlWriter.startElement("DomainName").value(s3Origin.domainName()).endElement();
                        }
                        if (s3Origin.originAccessIdentity() != null) {
                            xmlWriter.startElement("OriginAccessIdentity").value(s3Origin.originAccessIdentity()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((aliases = streamingDistributionConfig.aliases()) != null) {
                        List<String> aliasesItemsList;
                        xmlWriter.startElement("Aliases");
                        if (aliases.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)aliases.quantity()).endElement();
                        }
                        if ((aliasesItemsList = aliases.items()) != null) {
                            xmlWriter.startElement("Items");
                            for (String aliasesItemsListValue : aliasesItemsList) {
                                xmlWriter.startElement("CNAME");
                                xmlWriter.value(aliasesItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (streamingDistributionConfig.comment() != null) {
                        xmlWriter.startElement("Comment").value(streamingDistributionConfig.comment()).endElement();
                    }
                    if ((logging = streamingDistributionConfig.logging()) != null) {
                        xmlWriter.startElement("Logging");
                        if (logging.enabled() != null) {
                            xmlWriter.startElement("Enabled").value((Object)logging.enabled()).endElement();
                        }
                        if (logging.bucket() != null) {
                            xmlWriter.startElement("Bucket").value(logging.bucket()).endElement();
                        }
                        if (logging.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(logging.prefix()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((trustedSigners = streamingDistributionConfig.trustedSigners()) != null) {
                        List<String> trustedSignersItemsList;
                        xmlWriter.startElement("TrustedSigners");
                        if (trustedSigners.enabled() != null) {
                            xmlWriter.startElement("Enabled").value((Object)trustedSigners.enabled()).endElement();
                        }
                        if (trustedSigners.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)trustedSigners.quantity()).endElement();
                        }
                        if ((trustedSignersItemsList = trustedSigners.items()) != null) {
                            xmlWriter.startElement("Items");
                            for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                                xmlWriter.startElement("AwsAccountNumber");
                                xmlWriter.value(trustedSignersItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (streamingDistributionConfig.priceClassString() != null) {
                        xmlWriter.startElement("PriceClass").value(streamingDistributionConfig.priceClassString()).endElement();
                    }
                    if (streamingDistributionConfig.enabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)streamingDistributionConfig.enabled()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((tags = streamingDistributionConfigWithTags.tags()) != null) {
                    xmlWriter.startElement("Tags");
                    List<Tag> tagsItemsList = tags.items();
                    if (tagsItemsList != null) {
                        xmlWriter.startElement("Items");
                        for (Tag tagsItemsListValue : tagsItemsList) {
                            xmlWriter.startElement("Tag");
                            if (tagsItemsListValue.key() != null) {
                                xmlWriter.startElement("Key").value(tagsItemsListValue.key()).endElement();
                            }
                            if (tagsItemsListValue.value() != null) {
                                xmlWriter.startElement("Value").value(tagsItemsListValue.value()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

