/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDistributionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateDistributionRequest> {
    private final DistributionConfig distributionConfig;
    private final String id;
    private final String ifMatch;

    private UpdateDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionConfig = builder.distributionConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    public DistributionConfig distributionConfig() {
        return this.distributionConfig;
    }

    public String id() {
        return this.id;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionRequest)) {
            return false;
        }
        UpdateDistributionRequest other = (UpdateDistributionRequest)((Object)obj);
        return Objects.equals(this.distributionConfig(), other.distributionConfig()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDistributionRequest").add("DistributionConfig", (Object)this.distributionConfig()).add("Id", (Object)this.id()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionConfig": {
                return Optional.of(clazz.cast(this.distributionConfig()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.of(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private DistributionConfig distributionConfig;
        private String id;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionRequest model) {
            this.distributionConfig(model.distributionConfig);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return this.distributionConfig != null ? this.distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionRequest build() {
            return new UpdateDistributionRequest(this);
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    CopyableBuilder<Builder, UpdateDistributionRequest> {
        public Builder distributionConfig(DistributionConfig var1);

        default public Builder distributionConfig(Consumer<DistributionConfig.Builder> distributionConfig) {
            return this.distributionConfig((DistributionConfig)((DistributionConfig.Builder)DistributionConfig.builder().apply(distributionConfig)).build());
        }

        public Builder id(String var1);

        public Builder ifMatch(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

