/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCloudFrontOriginAccessIdentitiesRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, ListCloudFrontOriginAccessIdentitiesRequest> {
    private final String marker;
    private final String maxItems;

    private ListCloudFrontOriginAccessIdentitiesRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public String marker() {
        return this.marker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudFrontOriginAccessIdentitiesRequest)) {
            return false;
        }
        ListCloudFrontOriginAccessIdentitiesRequest other = (ListCloudFrontOriginAccessIdentitiesRequest)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListCloudFrontOriginAccessIdentitiesRequest").add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String marker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudFrontOriginAccessIdentitiesRequest model) {
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListCloudFrontOriginAccessIdentitiesRequest build() {
            return new ListCloudFrontOriginAccessIdentitiesRequest(this);
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    CopyableBuilder<Builder, ListCloudFrontOriginAccessIdentitiesRequest> {
        public Builder marker(String var1);

        public Builder maxItems(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

