/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.AllowedMethods;
import software.amazon.awssdk.services.cloudfront.model.ForwardedValues;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CacheBehavior
implements ToCopyableBuilder<Builder, CacheBehavior> {
    private final String pathPattern;
    private final String targetOriginId;
    private final ForwardedValues forwardedValues;
    private final TrustedSigners trustedSigners;
    private final String viewerProtocolPolicy;
    private final Long minTTL;
    private final AllowedMethods allowedMethods;
    private final Boolean smoothStreaming;
    private final Long defaultTTL;
    private final Long maxTTL;
    private final Boolean compress;
    private final LambdaFunctionAssociations lambdaFunctionAssociations;

    private CacheBehavior(BuilderImpl builder) {
        this.pathPattern = builder.pathPattern;
        this.targetOriginId = builder.targetOriginId;
        this.forwardedValues = builder.forwardedValues;
        this.trustedSigners = builder.trustedSigners;
        this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        this.minTTL = builder.minTTL;
        this.allowedMethods = builder.allowedMethods;
        this.smoothStreaming = builder.smoothStreaming;
        this.defaultTTL = builder.defaultTTL;
        this.maxTTL = builder.maxTTL;
        this.compress = builder.compress;
        this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
    }

    public String pathPattern() {
        return this.pathPattern;
    }

    public String targetOriginId() {
        return this.targetOriginId;
    }

    public ForwardedValues forwardedValues() {
        return this.forwardedValues;
    }

    public TrustedSigners trustedSigners() {
        return this.trustedSigners;
    }

    public ViewerProtocolPolicy viewerProtocolPolicy() {
        return ViewerProtocolPolicy.fromValue(this.viewerProtocolPolicy);
    }

    public String viewerProtocolPolicyString() {
        return this.viewerProtocolPolicy;
    }

    public Long minTTL() {
        return this.minTTL;
    }

    public AllowedMethods allowedMethods() {
        return this.allowedMethods;
    }

    public Boolean smoothStreaming() {
        return this.smoothStreaming;
    }

    public Long defaultTTL() {
        return this.defaultTTL;
    }

    public Long maxTTL() {
        return this.maxTTL;
    }

    public Boolean compress() {
        return this.compress;
    }

    public LambdaFunctionAssociations lambdaFunctionAssociations() {
        return this.lambdaFunctionAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOriginId());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerProtocolPolicyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedMethods());
        hashCode = 31 * hashCode + Objects.hashCode(this.smoothStreaming());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTTL());
        hashCode = 31 * hashCode + Objects.hashCode(this.compress());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionAssociations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheBehavior)) {
            return false;
        }
        CacheBehavior other = (CacheBehavior)obj;
        return Objects.equals(this.pathPattern(), other.pathPattern()) && Objects.equals(this.targetOriginId(), other.targetOriginId()) && Objects.equals(this.forwardedValues(), other.forwardedValues()) && Objects.equals(this.trustedSigners(), other.trustedSigners()) && Objects.equals(this.viewerProtocolPolicyString(), other.viewerProtocolPolicyString()) && Objects.equals(this.minTTL(), other.minTTL()) && Objects.equals(this.allowedMethods(), other.allowedMethods()) && Objects.equals(this.smoothStreaming(), other.smoothStreaming()) && Objects.equals(this.defaultTTL(), other.defaultTTL()) && Objects.equals(this.maxTTL(), other.maxTTL()) && Objects.equals(this.compress(), other.compress()) && Objects.equals(this.lambdaFunctionAssociations(), other.lambdaFunctionAssociations());
    }

    public String toString() {
        return ToString.builder((String)"CacheBehavior").add("PathPattern", (Object)this.pathPattern()).add("TargetOriginId", (Object)this.targetOriginId()).add("ForwardedValues", (Object)this.forwardedValues()).add("TrustedSigners", (Object)this.trustedSigners()).add("ViewerProtocolPolicy", (Object)this.viewerProtocolPolicyString()).add("MinTTL", (Object)this.minTTL()).add("AllowedMethods", (Object)this.allowedMethods()).add("SmoothStreaming", (Object)this.smoothStreaming()).add("DefaultTTL", (Object)this.defaultTTL()).add("MaxTTL", (Object)this.maxTTL()).add("Compress", (Object)this.compress()).add("LambdaFunctionAssociations", (Object)this.lambdaFunctionAssociations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PathPattern": {
                return Optional.of(clazz.cast(this.pathPattern()));
            }
            case "TargetOriginId": {
                return Optional.of(clazz.cast(this.targetOriginId()));
            }
            case "ForwardedValues": {
                return Optional.of(clazz.cast(this.forwardedValues()));
            }
            case "TrustedSigners": {
                return Optional.of(clazz.cast(this.trustedSigners()));
            }
            case "ViewerProtocolPolicy": {
                return Optional.of(clazz.cast(this.viewerProtocolPolicyString()));
            }
            case "MinTTL": {
                return Optional.of(clazz.cast(this.minTTL()));
            }
            case "AllowedMethods": {
                return Optional.of(clazz.cast(this.allowedMethods()));
            }
            case "SmoothStreaming": {
                return Optional.of(clazz.cast(this.smoothStreaming()));
            }
            case "DefaultTTL": {
                return Optional.of(clazz.cast(this.defaultTTL()));
            }
            case "MaxTTL": {
                return Optional.of(clazz.cast(this.maxTTL()));
            }
            case "Compress": {
                return Optional.of(clazz.cast(this.compress()));
            }
            case "LambdaFunctionAssociations": {
                return Optional.of(clazz.cast(this.lambdaFunctionAssociations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pathPattern;
        private String targetOriginId;
        private ForwardedValues forwardedValues;
        private TrustedSigners trustedSigners;
        private String viewerProtocolPolicy;
        private Long minTTL;
        private AllowedMethods allowedMethods;
        private Boolean smoothStreaming;
        private Long defaultTTL;
        private Long maxTTL;
        private Boolean compress;
        private LambdaFunctionAssociations lambdaFunctionAssociations;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheBehavior model) {
            this.pathPattern(model.pathPattern);
            this.targetOriginId(model.targetOriginId);
            this.forwardedValues(model.forwardedValues);
            this.trustedSigners(model.trustedSigners);
            this.viewerProtocolPolicy(model.viewerProtocolPolicy);
            this.minTTL(model.minTTL);
            this.allowedMethods(model.allowedMethods);
            this.smoothStreaming(model.smoothStreaming);
            this.defaultTTL(model.defaultTTL);
            this.maxTTL(model.maxTTL);
            this.compress(model.compress);
            this.lambdaFunctionAssociations(model.lambdaFunctionAssociations);
        }

        public final String getPathPattern() {
            return this.pathPattern;
        }

        @Override
        public final Builder pathPattern(String pathPattern) {
            this.pathPattern = pathPattern;
            return this;
        }

        public final void setPathPattern(String pathPattern) {
            this.pathPattern = pathPattern;
        }

        public final String getTargetOriginId() {
            return this.targetOriginId;
        }

        @Override
        public final Builder targetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
            return this;
        }

        public final void setTargetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
        }

        public final ForwardedValues.Builder getForwardedValues() {
            return this.forwardedValues != null ? this.forwardedValues.toBuilder() : null;
        }

        @Override
        public final Builder forwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        public final void setForwardedValues(ForwardedValues.BuilderImpl forwardedValues) {
            this.forwardedValues = forwardedValues != null ? forwardedValues.build() : null;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return this.trustedSigners != null ? this.trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final String getViewerProtocolPolicy() {
            return this.viewerProtocolPolicy;
        }

        @Override
        public final Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        @Override
        public final Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy.toString());
            return this;
        }

        public final void setViewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        public final Long getMinTTL() {
            return this.minTTL;
        }

        @Override
        public final Builder minTTL(Long minTTL) {
            this.minTTL = minTTL;
            return this;
        }

        public final void setMinTTL(Long minTTL) {
            this.minTTL = minTTL;
        }

        public final AllowedMethods.Builder getAllowedMethods() {
            return this.allowedMethods != null ? this.allowedMethods.toBuilder() : null;
        }

        @Override
        public final Builder allowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public final void setAllowedMethods(AllowedMethods.BuilderImpl allowedMethods) {
            this.allowedMethods = allowedMethods != null ? allowedMethods.build() : null;
        }

        public final Boolean getSmoothStreaming() {
            return this.smoothStreaming;
        }

        @Override
        public final Builder smoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        public final void setSmoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
        }

        public final Long getDefaultTTL() {
            return this.defaultTTL;
        }

        @Override
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        public final Long getMaxTTL() {
            return this.maxTTL;
        }

        @Override
        public final Builder maxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
            return this;
        }

        public final void setMaxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
        }

        public final Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final Builder compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public final void setCompress(Boolean compress) {
            this.compress = compress;
        }

        public final LambdaFunctionAssociations.Builder getLambdaFunctionAssociations() {
            return this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.toBuilder() : null;
        }

        @Override
        public final Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
            return this;
        }

        public final void setLambdaFunctionAssociations(LambdaFunctionAssociations.BuilderImpl lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations != null ? lambdaFunctionAssociations.build() : null;
        }

        public CacheBehavior build() {
            return new CacheBehavior(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CacheBehavior> {
        public Builder pathPattern(String var1);

        public Builder targetOriginId(String var1);

        public Builder forwardedValues(ForwardedValues var1);

        default public Builder forwardedValues(Consumer<ForwardedValues.Builder> forwardedValues) {
            return this.forwardedValues((ForwardedValues)((ForwardedValues.Builder)ForwardedValues.builder().apply(forwardedValues)).build());
        }

        public Builder trustedSigners(TrustedSigners var1);

        default public Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return this.trustedSigners((TrustedSigners)((TrustedSigners.Builder)TrustedSigners.builder().apply(trustedSigners)).build());
        }

        public Builder viewerProtocolPolicy(String var1);

        public Builder viewerProtocolPolicy(ViewerProtocolPolicy var1);

        public Builder minTTL(Long var1);

        public Builder allowedMethods(AllowedMethods var1);

        default public Builder allowedMethods(Consumer<AllowedMethods.Builder> allowedMethods) {
            return this.allowedMethods((AllowedMethods)((AllowedMethods.Builder)AllowedMethods.builder().apply(allowedMethods)).build());
        }

        public Builder smoothStreaming(Boolean var1);

        public Builder defaultTTL(Long var1);

        public Builder maxTTL(Long var1);

        public Builder compress(Boolean var1);

        public Builder lambdaFunctionAssociations(LambdaFunctionAssociations var1);

        default public Builder lambdaFunctionAssociations(Consumer<LambdaFunctionAssociations.Builder> lambdaFunctionAssociations) {
            return this.lambdaFunctionAssociations((LambdaFunctionAssociations)((LambdaFunctionAssociations.Builder)LambdaFunctionAssociations.builder().apply(lambdaFunctionAssociations)).build());
        }
    }
}

