/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;

public final class ListCloudFrontOriginAccessIdentitiesPaginator
implements SdkIterable<ListCloudFrontOriginAccessIdentitiesResponse> {
    private final CloudFrontClient client;
    private final ListCloudFrontOriginAccessIdentitiesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListCloudFrontOriginAccessIdentitiesPaginator(CloudFrontClient client, ListCloudFrontOriginAccessIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCloudFrontOriginAccessIdentitiesResponseFetcher();
    }

    public Iterator<ListCloudFrontOriginAccessIdentitiesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<CloudFrontOriginAccessIdentitySummary> items() {
        Function<ListCloudFrontOriginAccessIdentitiesResponse, Iterator> getIterator = response -> response != null ? response.cloudFrontOriginAccessIdentityList().items().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListCloudFrontOriginAccessIdentitiesResponseFetcher
    implements NextPageFetcher<ListCloudFrontOriginAccessIdentitiesResponse> {
        private ListCloudFrontOriginAccessIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudFrontOriginAccessIdentitiesResponse previousPage) {
            return previousPage.cloudFrontOriginAccessIdentityList().isTruncated();
        }

        public ListCloudFrontOriginAccessIdentitiesResponse nextPage(ListCloudFrontOriginAccessIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListCloudFrontOriginAccessIdentitiesPaginator.this.client.listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesPaginator.this.firstRequest);
            }
            return ListCloudFrontOriginAccessIdentitiesPaginator.this.client.listCloudFrontOriginAccessIdentities((ListCloudFrontOriginAccessIdentitiesRequest)((Object)ListCloudFrontOriginAccessIdentitiesPaginator.this.firstRequest.toBuilder().marker(previousPage.cloudFrontOriginAccessIdentityList().nextMarker()).build()));
        }
    }
}

