/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudfront.model.EventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LambdaFunctionAssociation
implements ToCopyableBuilder<Builder, LambdaFunctionAssociation> {
    private final String lambdaFunctionARN;
    private final String eventType;

    private LambdaFunctionAssociation(BuilderImpl builder) {
        this.lambdaFunctionARN = builder.lambdaFunctionARN;
        this.eventType = builder.eventType;
    }

    public String lambdaFunctionARN() {
        return this.lambdaFunctionARN;
    }

    public EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public String eventTypeString() {
        return this.eventType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociation)) {
            return false;
        }
        LambdaFunctionAssociation other = (LambdaFunctionAssociation)obj;
        return Objects.equals(this.lambdaFunctionARN(), other.lambdaFunctionARN()) && Objects.equals(this.eventTypeString(), other.eventTypeString());
    }

    public String toString() {
        return ToString.builder((String)"LambdaFunctionAssociation").add("LambdaFunctionARN", (Object)this.lambdaFunctionARN()).add("EventType", (Object)this.eventTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaFunctionARN": {
                return Optional.of(clazz.cast(this.lambdaFunctionARN()));
            }
            case "EventType": {
                return Optional.of(clazz.cast(this.eventTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaFunctionARN;
        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociation model) {
            this.lambdaFunctionARN(model.lambdaFunctionARN);
            this.eventType(model.eventType);
        }

        public final String getLambdaFunctionARN() {
            return this.lambdaFunctionARN;
        }

        @Override
        public final Builder lambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
            return this;
        }

        public final void setLambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public LambdaFunctionAssociation build() {
            return new LambdaFunctionAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LambdaFunctionAssociation> {
        public Builder lambdaFunctionARN(String var1);

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);
    }
}

