/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudFrontOriginAccessIdentity
implements ToCopyableBuilder<Builder, CloudFrontOriginAccessIdentity> {
    private final String id;
    private final String s3CanonicalUserId;
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private CloudFrontOriginAccessIdentity(BuilderImpl builder) {
        this.id = builder.id;
        this.s3CanonicalUserId = builder.s3CanonicalUserId;
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
    }

    public String id() {
        return this.id;
    }

    public String s3CanonicalUserId() {
        return this.s3CanonicalUserId;
    }

    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return this.cloudFrontOriginAccessIdentityConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3CanonicalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontOriginAccessIdentityConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentity)) {
            return false;
        }
        CloudFrontOriginAccessIdentity other = (CloudFrontOriginAccessIdentity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.s3CanonicalUserId(), other.s3CanonicalUserId()) && Objects.equals(this.cloudFrontOriginAccessIdentityConfig(), other.cloudFrontOriginAccessIdentityConfig());
    }

    public String toString() {
        return ToString.builder((String)"CloudFrontOriginAccessIdentity").add("Id", (Object)this.id()).add("S3CanonicalUserId", (Object)this.s3CanonicalUserId()).add("CloudFrontOriginAccessIdentityConfig", (Object)this.cloudFrontOriginAccessIdentityConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "S3CanonicalUserId": {
                return Optional.of(clazz.cast(this.s3CanonicalUserId()));
            }
            case "CloudFrontOriginAccessIdentityConfig": {
                return Optional.of(clazz.cast(this.cloudFrontOriginAccessIdentityConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String s3CanonicalUserId;
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentity model) {
            this.id(model.id);
            this.s3CanonicalUserId(model.s3CanonicalUserId);
            this.cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getS3CanonicalUserId() {
            return this.s3CanonicalUserId;
        }

        @Override
        public final Builder s3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
            return this;
        }

        public final void setS3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return this.cloudFrontOriginAccessIdentityConfig != null ? this.cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.build() : null;
        }

        public CloudFrontOriginAccessIdentity build() {
            return new CloudFrontOriginAccessIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudFrontOriginAccessIdentity> {
        public Builder id(String var1);

        public Builder s3CanonicalUserId(String var1);

        public Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig var1);

        default public Builder cloudFrontOriginAccessIdentityConfig(Consumer<CloudFrontOriginAccessIdentityConfig.Builder> cloudFrontOriginAccessIdentityConfig) {
            return this.cloudFrontOriginAccessIdentityConfig((CloudFrontOriginAccessIdentityConfig)((CloudFrontOriginAccessIdentityConfig.Builder)CloudFrontOriginAccessIdentityConfig.builder().apply(cloudFrontOriginAccessIdentityConfig)).build());
        }
    }
}

