/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;

public class ListInvalidationsRequestMarshaller
implements Marshaller<Request<ListInvalidationsRequest>, ListInvalidationsRequest> {
    public Request<ListInvalidationsRequest> marshall(ListInvalidationsRequest listInvalidationsRequest) {
        if (listInvalidationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listInvalidationsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/distribution/{DistributionId}/invalidation";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "DistributionId", listInvalidationsRequest.distributionId());
        request.setResourcePath(uriResourcePath);
        if (listInvalidationsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listInvalidationsRequest.marker()));
        }
        if (listInvalidationsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString((String)listInvalidationsRequest.maxItems()));
        }
        return request;
    }
}

