/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CustomHeaders;
import software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader;
import software.amazon.awssdk.services.cloudfront.transform.OriginCustomHeaderUnmarshaller;

public class CustomHeadersUnmarshaller
implements Unmarshaller<CustomHeaders, StaxUnmarshallerContext> {
    private static final CustomHeadersUnmarshaller INSTANCE = new CustomHeadersUnmarshaller();

    public CustomHeaders unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomHeaders.Builder customHeaders;
        block6: {
            customHeaders = CustomHeaders.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<OriginCustomHeader> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    customHeaders.items(items);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Quantity", targetDepth)) {
                        customHeaders.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<OriginCustomHeader>();
                        continue;
                    }
                    if (!context.testExpression("Items/OriginCustomHeader", targetDepth)) continue;
                    items.add(OriginCustomHeaderUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            customHeaders.items(items);
        }
        return (CustomHeaders)customHeaders.build();
    }

    public static CustomHeadersUnmarshaller getInstance() {
        return INSTANCE;
    }
}

