/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CookiePreference;
import software.amazon.awssdk.services.cloudfront.transform.CookieNamesUnmarshaller;

public class CookiePreferenceUnmarshaller
implements Unmarshaller<CookiePreference, StaxUnmarshallerContext> {
    private static final CookiePreferenceUnmarshaller INSTANCE = new CookiePreferenceUnmarshaller();

    public CookiePreference unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CookiePreference.Builder cookiePreference = CookiePreference.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Forward", targetDepth)) {
                    cookiePreference.forward(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("WhitelistedNames", targetDepth)) continue;
                cookiePreference.whitelistedNames(CookieNamesUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CookiePreference)cookiePreference.build();
    }

    public static CookiePreferenceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

