/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateStreamingDistributionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateStreamingDistributionRequest> {
    private final StreamingDistributionConfig streamingDistributionConfig;
    private final String id;
    private final String ifMatch;

    private UpdateStreamingDistributionRequest(BuilderImpl builder) {
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    public StreamingDistributionConfig streamingDistributionConfig() {
        return this.streamingDistributionConfig;
    }

    public String id() {
        return this.id;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingDistributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamingDistributionRequest)) {
            return false;
        }
        UpdateStreamingDistributionRequest other = (UpdateStreamingDistributionRequest)((Object)obj);
        return Objects.equals(this.streamingDistributionConfig(), other.streamingDistributionConfig()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamingDistributionConfig() != null) {
            sb.append("StreamingDistributionConfig: ").append(this.streamingDistributionConfig()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.ifMatch() != null) {
            sb.append("IfMatch: ").append(this.ifMatch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingDistributionConfig": {
                return Optional.of(clazz.cast(this.streamingDistributionConfig()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.of(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;
        private String id;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamingDistributionRequest model) {
            this.streamingDistributionConfig(model.streamingDistributionConfig);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return this.streamingDistributionConfig != null ? this.streamingDistributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        public UpdateStreamingDistributionRequest build() {
            return new UpdateStreamingDistributionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateStreamingDistributionRequest> {
        public Builder streamingDistributionConfig(StreamingDistributionConfig var1);

        default public Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return this.streamingDistributionConfig((StreamingDistributionConfig)((StreamingDistributionConfig.Builder)StreamingDistributionConfig.builder().apply(streamingDistributionConfig)).build());
        }

        public Builder id(String var1);

        public Builder ifMatch(String var1);
    }
}

