/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.cloudfront.model.TagKeys;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;

public class UntagResourceRequestMarshaller
implements Marshaller<Request<UntagResourceRequest>, UntagResourceRequest> {
    public Request<UntagResourceRequest> marshall(UntagResourceRequest untagResourceRequest) {
        if (untagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)untagResourceRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2017-03-25/tagging?Operation=Untag";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (untagResourceRequest.resource() != null) {
            request.addParameter("Resource", StringUtils.fromString((String)untagResourceRequest.resource()));
        }
        try {
            StringWriter stringWriter = null;
            TagKeys tagKeys = untagResourceRequest.tagKeys();
            if (tagKeys != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("TagKeys");
                List<String> tagKeysItemsList = tagKeys.items();
                if (tagKeysItemsList != null) {
                    xmlWriter.startElement("Items");
                    for (String tagKeysItemsListValue : tagKeysItemsList) {
                        xmlWriter.startElement("Key");
                        xmlWriter.value(tagKeysItemsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

