/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateDistributionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateDistributionRequest> {
    private final DistributionConfig distributionConfig;
    private final String id;
    private final String ifMatch;

    private UpdateDistributionRequest(BuilderImpl builder) {
        this.distributionConfig = builder.distributionConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    public DistributionConfig distributionConfig() {
        return this.distributionConfig;
    }

    public String id() {
        return this.id;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.distributionConfig() == null ? 0 : this.distributionConfig().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.ifMatch() == null ? 0 : this.ifMatch().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionRequest)) {
            return false;
        }
        UpdateDistributionRequest other = (UpdateDistributionRequest)((Object)obj);
        if (other.distributionConfig() == null ^ this.distributionConfig() == null) {
            return false;
        }
        if (other.distributionConfig() != null && !other.distributionConfig().equals(this.distributionConfig())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.ifMatch() == null ^ this.ifMatch() == null) {
            return false;
        }
        return other.ifMatch() == null || other.ifMatch().equals(this.ifMatch());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.distributionConfig() != null) {
            sb.append("DistributionConfig: ").append(this.distributionConfig()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.ifMatch() != null) {
            sb.append("IfMatch: ").append(this.ifMatch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionConfig": {
                return Optional.of(clazz.cast(this.distributionConfig()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.of(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private DistributionConfig distributionConfig;
        private String id;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionRequest model) {
            this.distributionConfig(model.distributionConfig);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return this.distributionConfig != null ? this.distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        public UpdateDistributionRequest build() {
            return new UpdateDistributionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateDistributionRequest> {
        public Builder distributionConfig(DistributionConfig var1);

        public Builder id(String var1);

        public Builder ifMatch(String var1);
    }
}

