/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudfront.model.Origin;
import software.amazon.awssdk.services.cloudfront.model.OriginListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Origins
implements ToCopyableBuilder<Builder, Origins> {
    private final Integer quantity;
    private final List<Origin> items;

    private Origins(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<Origin> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.quantity() == null ? 0 : this.quantity().hashCode());
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origins)) {
            return false;
        }
        Origins other = (Origins)obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.of(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<Origin> items;

        private BuilderImpl() {
        }

        private BuilderImpl(Origins model) {
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<Origin.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(Origin::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<Origin> items) {
            this.items = OriginListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Origin ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<Origin.BuilderImpl> items) {
            this.items = OriginListCopier.copyFromBuilder(items);
        }

        public Origins build() {
            return new Origins(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Origins> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<Origin> var1);

        public Builder items(Origin ... var1);
    }
}

