/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoggingConfig
implements ToCopyableBuilder<Builder, LoggingConfig> {
    private final Boolean enabled;
    private final Boolean includeCookies;
    private final String bucket;
    private final String prefix;

    private LoggingConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.includeCookies = builder.includeCookies;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean includeCookies() {
        return this.includeCookies;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.includeCookies() == null ? 0 : this.includeCookies().hashCode());
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.includeCookies() == null ^ this.includeCookies() == null) {
            return false;
        }
        if (other.includeCookies() != null && !other.includeCookies().equals(this.includeCookies())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        return other.prefix() == null || other.prefix().equals(this.prefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.includeCookies() != null) {
            sb.append("IncludeCookies: ").append(this.includeCookies()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "IncludeCookies": {
                return Optional.of(clazz.cast(this.includeCookies()));
            }
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean includeCookies;
        private String bucket;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            this.enabled(model.enabled);
            this.includeCookies(model.includeCookies);
            this.bucket(model.bucket);
            this.prefix(model.prefix);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getIncludeCookies() {
            return this.includeCookies;
        }

        @Override
        public final Builder includeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
            return this;
        }

        public final void setIncludeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public LoggingConfig build() {
            return new LoggingConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoggingConfig> {
        public Builder enabled(Boolean var1);

        public Builder includeCookies(Boolean var1);

        public Builder bucket(String var1);

        public Builder prefix(String var1);
    }
}

