/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistribution;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateStreamingDistributionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateStreamingDistributionResponse> {
    private final StreamingDistribution streamingDistribution;
    private final String location;
    private final String eTag;

    private CreateStreamingDistributionResponse(BuilderImpl builder) {
        this.streamingDistribution = builder.streamingDistribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    public StreamingDistribution streamingDistribution() {
        return this.streamingDistribution;
    }

    public String location() {
        return this.location;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamingDistribution() == null ? 0 : this.streamingDistribution().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.eTag() == null ? 0 : this.eTag().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionResponse)) {
            return false;
        }
        CreateStreamingDistributionResponse other = (CreateStreamingDistributionResponse)((Object)obj);
        if (other.streamingDistribution() == null ^ this.streamingDistribution() == null) {
            return false;
        }
        if (other.streamingDistribution() != null && !other.streamingDistribution().equals(this.streamingDistribution())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        return other.eTag() == null || other.eTag().equals(this.eTag());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.streamingDistribution() != null) {
            sb.append("StreamingDistribution: ").append(this.streamingDistribution()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingDistribution": {
                return Optional.of(clazz.cast(this.streamingDistribution()));
            }
            case "Location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private StreamingDistribution streamingDistribution;
        private String location;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionResponse model) {
            this.streamingDistribution(model.streamingDistribution);
            this.location(model.location);
            this.eTag(model.eTag);
        }

        public final StreamingDistribution.Builder getStreamingDistribution() {
            return this.streamingDistribution != null ? this.streamingDistribution.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
            return this;
        }

        public final void setStreamingDistribution(StreamingDistribution.BuilderImpl streamingDistribution) {
            this.streamingDistribution = streamingDistribution != null ? streamingDistribution.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public CreateStreamingDistributionResponse build() {
            return new CreateStreamingDistributionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateStreamingDistributionResponse> {
        public Builder streamingDistribution(StreamingDistribution var1);

        public Builder location(String var1);

        public Builder eTag(String var1);
    }
}

