/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.Origin;
import software.amazon.awssdk.services.cloudfront.transform.CustomHeadersUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CustomOriginConfigUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.S3OriginConfigUnmarshaller;

public class OriginUnmarshaller
implements Unmarshaller<Origin, StaxUnmarshallerContext> {
    private static final OriginUnmarshaller INSTANCE = new OriginUnmarshaller();

    public Origin unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Origin.Builder origin = Origin.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    origin.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DomainName", targetDepth)) {
                    origin.domainName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OriginPath", targetDepth)) {
                    origin.originPath(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomHeaders", targetDepth)) {
                    origin.customHeaders(CustomHeadersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3OriginConfig", targetDepth)) {
                    origin.s3OriginConfig(S3OriginConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CustomOriginConfig", targetDepth)) continue;
                origin.customOriginConfig(CustomOriginConfigUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Origin)origin.build();
    }

    public static OriginUnmarshaller getInstance() {
        return INSTANCE;
    }
}

