/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.DistributionList;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.transform.DistributionSummaryUnmarshaller;

public class DistributionListUnmarshaller
implements Unmarshaller<DistributionList, StaxUnmarshallerContext> {
    private static final DistributionListUnmarshaller INSTANCE = new DistributionListUnmarshaller();

    public DistributionList unmarshall(StaxUnmarshallerContext context) throws Exception {
        DistributionList.Builder distributionList;
        block10: {
            distributionList = DistributionList.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<DistributionSummary> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    distributionList.items(items);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Marker", targetDepth)) {
                        distributionList.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextMarker", targetDepth)) {
                        distributionList.nextMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MaxItems", targetDepth)) {
                        distributionList.maxItems(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IsTruncated", targetDepth)) {
                        distributionList.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Quantity", targetDepth)) {
                        distributionList.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<DistributionSummary>();
                        continue;
                    }
                    if (!context.testExpression("Items/DistributionSummary", targetDepth)) continue;
                    items.add(DistributionSummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            distributionList.items(items);
        }
        return (DistributionList)distributionList.build();
    }

    public static DistributionListUnmarshaller getInstance() {
        return INSTANCE;
    }
}

