/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CookieNames;

public class CookieNamesUnmarshaller
implements Unmarshaller<CookieNames, StaxUnmarshallerContext> {
    private static final CookieNamesUnmarshaller INSTANCE = new CookieNamesUnmarshaller();

    public CookieNames unmarshall(StaxUnmarshallerContext context) throws Exception {
        CookieNames.Builder cookieNames;
        block6: {
            cookieNames = CookieNames.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cookieNames.items(items);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Quantity", targetDepth)) {
                        cookieNames.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("Items/Name", targetDepth)) continue;
                    items.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cookieNames.items(items);
        }
        return (CookieNames)cookieNames.build();
    }

    public static CookieNamesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

