/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy;
import software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CustomOriginConfig
implements ToCopyableBuilder<Builder, CustomOriginConfig> {
    private final Integer httpPort;
    private final Integer httpsPort;
    private final String originProtocolPolicy;
    private final OriginSslProtocols originSslProtocols;
    private final Integer originReadTimeout;
    private final Integer originKeepaliveTimeout;

    private CustomOriginConfig(BuilderImpl builder) {
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.originProtocolPolicy = builder.originProtocolPolicy;
        this.originSslProtocols = builder.originSslProtocols;
        this.originReadTimeout = builder.originReadTimeout;
        this.originKeepaliveTimeout = builder.originKeepaliveTimeout;
    }

    public Integer httpPort() {
        return this.httpPort;
    }

    public Integer httpsPort() {
        return this.httpsPort;
    }

    public String originProtocolPolicy() {
        return this.originProtocolPolicy;
    }

    public OriginSslProtocols originSslProtocols() {
        return this.originSslProtocols;
    }

    public Integer originReadTimeout() {
        return this.originReadTimeout;
    }

    public Integer originKeepaliveTimeout() {
        return this.originKeepaliveTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.httpPort() == null ? 0 : this.httpPort().hashCode());
        hashCode = 31 * hashCode + (this.httpsPort() == null ? 0 : this.httpsPort().hashCode());
        hashCode = 31 * hashCode + (this.originProtocolPolicy() == null ? 0 : this.originProtocolPolicy().hashCode());
        hashCode = 31 * hashCode + (this.originSslProtocols() == null ? 0 : this.originSslProtocols().hashCode());
        hashCode = 31 * hashCode + (this.originReadTimeout() == null ? 0 : this.originReadTimeout().hashCode());
        hashCode = 31 * hashCode + (this.originKeepaliveTimeout() == null ? 0 : this.originKeepaliveTimeout().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomOriginConfig)) {
            return false;
        }
        CustomOriginConfig other = (CustomOriginConfig)obj;
        if (other.httpPort() == null ^ this.httpPort() == null) {
            return false;
        }
        if (other.httpPort() != null && !other.httpPort().equals(this.httpPort())) {
            return false;
        }
        if (other.httpsPort() == null ^ this.httpsPort() == null) {
            return false;
        }
        if (other.httpsPort() != null && !other.httpsPort().equals(this.httpsPort())) {
            return false;
        }
        if (other.originProtocolPolicy() == null ^ this.originProtocolPolicy() == null) {
            return false;
        }
        if (other.originProtocolPolicy() != null && !other.originProtocolPolicy().equals(this.originProtocolPolicy())) {
            return false;
        }
        if (other.originSslProtocols() == null ^ this.originSslProtocols() == null) {
            return false;
        }
        if (other.originSslProtocols() != null && !other.originSslProtocols().equals(this.originSslProtocols())) {
            return false;
        }
        if (other.originReadTimeout() == null ^ this.originReadTimeout() == null) {
            return false;
        }
        if (other.originReadTimeout() != null && !other.originReadTimeout().equals(this.originReadTimeout())) {
            return false;
        }
        if (other.originKeepaliveTimeout() == null ^ this.originKeepaliveTimeout() == null) {
            return false;
        }
        return other.originKeepaliveTimeout() == null || other.originKeepaliveTimeout().equals(this.originKeepaliveTimeout());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.httpPort() != null) {
            sb.append("HTTPPort: ").append(this.httpPort()).append(",");
        }
        if (this.httpsPort() != null) {
            sb.append("HTTPSPort: ").append(this.httpsPort()).append(",");
        }
        if (this.originProtocolPolicy() != null) {
            sb.append("OriginProtocolPolicy: ").append(this.originProtocolPolicy()).append(",");
        }
        if (this.originSslProtocols() != null) {
            sb.append("OriginSslProtocols: ").append(this.originSslProtocols()).append(",");
        }
        if (this.originReadTimeout() != null) {
            sb.append("OriginReadTimeout: ").append(this.originReadTimeout()).append(",");
        }
        if (this.originKeepaliveTimeout() != null) {
            sb.append("OriginKeepaliveTimeout: ").append(this.originKeepaliveTimeout()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer httpPort;
        private Integer httpsPort;
        private String originProtocolPolicy;
        private OriginSslProtocols originSslProtocols;
        private Integer originReadTimeout;
        private Integer originKeepaliveTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomOriginConfig model) {
            this.setHTTPPort(model.httpPort);
            this.setHTTPSPort(model.httpsPort);
            this.setOriginProtocolPolicy(model.originProtocolPolicy);
            this.setOriginSslProtocols(model.originSslProtocols);
            this.setOriginReadTimeout(model.originReadTimeout);
            this.setOriginKeepaliveTimeout(model.originKeepaliveTimeout);
        }

        public final Integer getHTTPPort() {
            return this.httpPort;
        }

        @Override
        public final Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public final void setHTTPPort(Integer httpPort) {
            this.httpPort = httpPort;
        }

        public final Integer getHTTPSPort() {
            return this.httpsPort;
        }

        @Override
        public final Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public final void setHTTPSPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
        }

        public final String getOriginProtocolPolicy() {
            return this.originProtocolPolicy;
        }

        @Override
        public final Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        @Override
        public final Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy) {
            this.originProtocolPolicy(originProtocolPolicy.toString());
            return this;
        }

        public final void setOriginProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
        }

        public final OriginSslProtocols getOriginSslProtocols() {
            return this.originSslProtocols;
        }

        @Override
        public final Builder originSslProtocols(OriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
            return this;
        }

        public final void setOriginSslProtocols(OriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
        }

        public final Integer getOriginReadTimeout() {
            return this.originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        public final Integer getOriginKeepaliveTimeout() {
            return this.originKeepaliveTimeout;
        }

        @Override
        public final Builder originKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        public final void setOriginKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
        }

        public CustomOriginConfig build() {
            return new CustomOriginConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomOriginConfig> {
        public Builder httpPort(Integer var1);

        public Builder httpsPort(Integer var1);

        public Builder originProtocolPolicy(String var1);

        public Builder originProtocolPolicy(OriginProtocolPolicy var1);

        public Builder originSslProtocols(OriginSslProtocols var1);

        public Builder originReadTimeout(Integer var1);

        public Builder originKeepaliveTimeout(Integer var1);
    }
}

