/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponseListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CustomErrorResponses
implements ToCopyableBuilder<Builder, CustomErrorResponses> {
    private final Integer quantity;
    private final List<CustomErrorResponse> items;

    private CustomErrorResponses(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<CustomErrorResponse> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.quantity() == null ? 0 : this.quantity().hashCode());
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomErrorResponses)) {
            return false;
        }
        CustomErrorResponses other = (CustomErrorResponses)obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<CustomErrorResponse> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomErrorResponses model) {
            this.setQuantity(model.quantity);
            this.setItems(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<CustomErrorResponse> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<CustomErrorResponse> items) {
            this.items = CustomErrorResponseListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CustomErrorResponse ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<CustomErrorResponse> items) {
            this.items = CustomErrorResponseListCopier.copy(items);
        }

        public CustomErrorResponses build() {
            return new CustomErrorResponses(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomErrorResponses> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<CustomErrorResponse> var1);

        public Builder items(CustomErrorResponse ... var1);
    }
}

