/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig;
import software.amazon.awssdk.services.cloudfront.transform.AliasesUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.S3OriginUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.StreamingLoggingConfigUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TrustedSignersUnmarshaller;

public class StreamingDistributionConfigUnmarshaller
implements Unmarshaller<StreamingDistributionConfig, StaxUnmarshallerContext> {
    private static final StreamingDistributionConfigUnmarshaller INSTANCE = new StreamingDistributionConfigUnmarshaller();

    public StreamingDistributionConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StreamingDistributionConfig.Builder streamingDistributionConfig = StreamingDistributionConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CallerReference", targetDepth)) {
                    streamingDistributionConfig.callerReference(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3Origin", targetDepth)) {
                    streamingDistributionConfig.s3Origin(S3OriginUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Aliases", targetDepth)) {
                    streamingDistributionConfig.aliases(AliasesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Comment", targetDepth)) {
                    streamingDistributionConfig.comment(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Logging", targetDepth)) {
                    streamingDistributionConfig.logging(StreamingLoggingConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TrustedSigners", targetDepth)) {
                    streamingDistributionConfig.trustedSigners(TrustedSignersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PriceClass", targetDepth)) {
                    streamingDistributionConfig.priceClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Enabled", targetDepth)) continue;
                streamingDistributionConfig.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StreamingDistributionConfig)streamingDistributionConfig.build();
    }

    public static StreamingDistributionConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

