/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListInvalidationsRequestMarshaller
implements Marshaller<Request<ListInvalidationsRequest>, ListInvalidationsRequest> {
    public Request<ListInvalidationsRequest> marshall(ListInvalidationsRequest listInvalidationsRequest) {
        if (listInvalidationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listInvalidationsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/distribution/{DistributionId}/invalidation";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "DistributionId", listInvalidationsRequest.distributionId());
        request.setResourcePath(uriResourcePath);
        if (listInvalidationsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)listInvalidationsRequest.marker()));
        }
        if (listInvalidationsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromString((String)listInvalidationsRequest.maxItems()));
        }
        return request;
    }
}

