/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.S3Origin;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig;
import software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.XmlWriter;

public class CreateStreamingDistributionRequestMarshaller
implements Marshaller<Request<CreateStreamingDistributionRequest>, CreateStreamingDistributionRequest> {
    public Request<CreateStreamingDistributionRequest> marshall(CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        if (createStreamingDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStreamingDistributionRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2017-03-25/streaming-distribution";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            StreamingDistributionConfig streamingDistributionConfig = createStreamingDistributionRequest.streamingDistributionConfig();
            if (streamingDistributionConfig != null) {
                TrustedSigners trustedSigners;
                StreamingLoggingConfig logging;
                Aliases aliases;
                S3Origin s3Origin;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("StreamingDistributionConfig");
                if (streamingDistributionConfig.callerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(streamingDistributionConfig.callerReference()).endElement();
                }
                if ((s3Origin = streamingDistributionConfig.s3Origin()) != null) {
                    xmlWriter.startElement("S3Origin");
                    if (s3Origin.domainName() != null) {
                        xmlWriter.startElement("DomainName").value(s3Origin.domainName()).endElement();
                    }
                    if (s3Origin.originAccessIdentity() != null) {
                        xmlWriter.startElement("OriginAccessIdentity").value(s3Origin.originAccessIdentity()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((aliases = streamingDistributionConfig.aliases()) != null) {
                    List<String> aliasesItemsList;
                    xmlWriter.startElement("Aliases");
                    if (aliases.quantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)aliases.quantity()).endElement();
                    }
                    if ((aliasesItemsList = aliases.items()) != null) {
                        xmlWriter.startElement("Items");
                        for (String aliasesItemsListValue : aliasesItemsList) {
                            xmlWriter.startElement("CNAME");
                            xmlWriter.value(aliasesItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (streamingDistributionConfig.comment() != null) {
                    xmlWriter.startElement("Comment").value(streamingDistributionConfig.comment()).endElement();
                }
                if ((logging = streamingDistributionConfig.logging()) != null) {
                    xmlWriter.startElement("Logging");
                    if (logging.enabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)logging.enabled()).endElement();
                    }
                    if (logging.bucket() != null) {
                        xmlWriter.startElement("Bucket").value(logging.bucket()).endElement();
                    }
                    if (logging.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(logging.prefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((trustedSigners = streamingDistributionConfig.trustedSigners()) != null) {
                    List<String> trustedSignersItemsList;
                    xmlWriter.startElement("TrustedSigners");
                    if (trustedSigners.enabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)trustedSigners.enabled()).endElement();
                    }
                    if (trustedSigners.quantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)trustedSigners.quantity()).endElement();
                    }
                    if ((trustedSignersItemsList = trustedSigners.items()) != null) {
                        xmlWriter.startElement("Items");
                        for (String trustedSignersItemsListValue : trustedSignersItemsList) {
                            xmlWriter.startElement("AwsAccountNumber");
                            xmlWriter.value(trustedSignersItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (streamingDistributionConfig.priceClass() != null) {
                    xmlWriter.startElement("PriceClass").value(streamingDistributionConfig.priceClass()).endElement();
                }
                if (streamingDistributionConfig.enabled() != null) {
                    xmlWriter.startElement("Enabled").value((Object)streamingDistributionConfig.enabled()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

