/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;

public class TrustedSignersUnmarshaller
implements Unmarshaller<TrustedSigners, StaxUnmarshallerContext> {
    private static TrustedSignersUnmarshaller INSTANCE;

    public TrustedSigners unmarshall(StaxUnmarshallerContext context) throws Exception {
        TrustedSigners.Builder trustedSigners;
        block7: {
            trustedSigners = TrustedSigners.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> items = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    trustedSigners.items(items);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Enabled", targetDepth)) {
                        trustedSigners.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Quantity", targetDepth)) {
                        trustedSigners.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Items", targetDepth)) {
                        items = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("Items/AwsAccountNumber", targetDepth)) continue;
                    items.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            trustedSigners.items(items);
        }
        return (TrustedSigners)trustedSigners.build();
    }

    public static TrustedSignersUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TrustedSignersUnmarshaller();
        }
        return INSTANCE;
    }
}

