/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior;
import software.amazon.awssdk.services.cloudfront.transform.AllowedMethodsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ForwardedValuesUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.LambdaFunctionAssociationsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TrustedSignersUnmarshaller;

public class DefaultCacheBehaviorUnmarshaller
implements Unmarshaller<DefaultCacheBehavior, StaxUnmarshallerContext> {
    private static DefaultCacheBehaviorUnmarshaller INSTANCE;

    public DefaultCacheBehavior unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DefaultCacheBehavior.Builder defaultCacheBehavior = DefaultCacheBehavior.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TargetOriginId", targetDepth)) {
                    defaultCacheBehavior.targetOriginId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ForwardedValues", targetDepth)) {
                    defaultCacheBehavior.forwardedValues(ForwardedValuesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TrustedSigners", targetDepth)) {
                    defaultCacheBehavior.trustedSigners(TrustedSignersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ViewerProtocolPolicy", targetDepth)) {
                    defaultCacheBehavior.viewerProtocolPolicy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinTTL", targetDepth)) {
                    defaultCacheBehavior.minTTL(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowedMethods", targetDepth)) {
                    defaultCacheBehavior.allowedMethods(AllowedMethodsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SmoothStreaming", targetDepth)) {
                    defaultCacheBehavior.smoothStreaming(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultTTL", targetDepth)) {
                    defaultCacheBehavior.defaultTTL(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxTTL", targetDepth)) {
                    defaultCacheBehavior.maxTTL(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Compress", targetDepth)) {
                    defaultCacheBehavior.compress(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LambdaFunctionAssociations", targetDepth)) continue;
                defaultCacheBehavior.lambdaFunctionAssociations(LambdaFunctionAssociationsUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DefaultCacheBehavior)defaultCacheBehavior.build();
    }

    public static DefaultCacheBehaviorUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultCacheBehaviorUnmarshaller();
        }
        return INSTANCE;
    }
}

