/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig;
import software.amazon.awssdk.services.cloudfront.transform.OriginSslProtocolsUnmarshaller;

public class CustomOriginConfigUnmarshaller
implements Unmarshaller<CustomOriginConfig, StaxUnmarshallerContext> {
    private static CustomOriginConfigUnmarshaller INSTANCE;

    public CustomOriginConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CustomOriginConfig.Builder customOriginConfig = CustomOriginConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HTTPPort", targetDepth)) {
                    customOriginConfig.httpPort(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HTTPSPort", targetDepth)) {
                    customOriginConfig.httpsPort(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OriginProtocolPolicy", targetDepth)) {
                    customOriginConfig.originProtocolPolicy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OriginSslProtocols", targetDepth)) {
                    customOriginConfig.originSslProtocols(OriginSslProtocolsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OriginReadTimeout", targetDepth)) {
                    customOriginConfig.originReadTimeout(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginKeepaliveTimeout", targetDepth)) continue;
                customOriginConfig.originKeepaliveTimeout(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CustomOriginConfig)customOriginConfig.build();
    }

    public static CustomOriginConfigUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomOriginConfigUnmarshaller();
        }
        return INSTANCE;
    }
}

