/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LambdaFunctionAssociations
implements ToCopyableBuilder<Builder, LambdaFunctionAssociations> {
    private final Integer quantity;
    private final List<LambdaFunctionAssociation> items;

    private LambdaFunctionAssociations(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<LambdaFunctionAssociation> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.quantity() == null ? 0 : this.quantity().hashCode());
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociations)) {
            return false;
        }
        LambdaFunctionAssociations other = (LambdaFunctionAssociations)obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<LambdaFunctionAssociation> items;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociations model) {
            this.setQuantity(model.quantity);
            this.setItems(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<LambdaFunctionAssociation> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<LambdaFunctionAssociation> items) {
            this.items = LambdaFunctionAssociationListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(LambdaFunctionAssociation ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<LambdaFunctionAssociation> items) {
            this.items = LambdaFunctionAssociationListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(LambdaFunctionAssociation ... items) {
            this.items(Arrays.asList(items));
        }

        public LambdaFunctionAssociations build() {
            return new LambdaFunctionAssociations(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LambdaFunctionAssociations> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<LambdaFunctionAssociation> var1);

        public Builder items(LambdaFunctionAssociation ... var1);
    }
}

