/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.services.cloudfront.model.CookieNames;
import software.amazon.awssdk.services.cloudfront.model.ItemSelection;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CookiePreference
implements ToCopyableBuilder<Builder, CookiePreference> {
    private final String forward;
    private final CookieNames whitelistedNames;

    private CookiePreference(BuilderImpl builder) {
        this.forward = builder.forward;
        this.whitelistedNames = builder.whitelistedNames;
    }

    public String forward() {
        return this.forward;
    }

    public CookieNames whitelistedNames() {
        return this.whitelistedNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.forward() == null ? 0 : this.forward().hashCode());
        hashCode = 31 * hashCode + (this.whitelistedNames() == null ? 0 : this.whitelistedNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookiePreference)) {
            return false;
        }
        CookiePreference other = (CookiePreference)obj;
        if (other.forward() == null ^ this.forward() == null) {
            return false;
        }
        if (other.forward() != null && !other.forward().equals(this.forward())) {
            return false;
        }
        if (other.whitelistedNames() == null ^ this.whitelistedNames() == null) {
            return false;
        }
        return other.whitelistedNames() == null || other.whitelistedNames().equals(this.whitelistedNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.forward() != null) {
            sb.append("Forward: ").append(this.forward()).append(",");
        }
        if (this.whitelistedNames() != null) {
            sb.append("WhitelistedNames: ").append(this.whitelistedNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String forward;
        private CookieNames whitelistedNames;

        private BuilderImpl() {
        }

        private BuilderImpl(CookiePreference model) {
            this.setForward(model.forward);
            this.setWhitelistedNames(model.whitelistedNames);
        }

        public final String getForward() {
            return this.forward;
        }

        @Override
        public final Builder forward(String forward) {
            this.forward = forward;
            return this;
        }

        @Override
        public final Builder forward(ItemSelection forward) {
            this.forward(forward.toString());
            return this;
        }

        public final void setForward(String forward) {
            this.forward = forward;
        }

        public final void setForward(ItemSelection forward) {
            this.forward(forward.toString());
        }

        public final CookieNames getWhitelistedNames() {
            return this.whitelistedNames;
        }

        @Override
        public final Builder whitelistedNames(CookieNames whitelistedNames) {
            this.whitelistedNames = whitelistedNames;
            return this;
        }

        public final void setWhitelistedNames(CookieNames whitelistedNames) {
            this.whitelistedNames = whitelistedNames;
        }

        public CookiePreference build() {
            return new CookiePreference(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CookiePreference> {
        public Builder forward(String var1);

        public Builder forward(ItemSelection var1);

        public Builder whitelistedNames(CookieNames var1);
    }
}

