/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.services.cloudfront.auth.PemObject;
import software.amazon.awssdk.services.cloudfront.auth.Rsa;
import software.amazon.awssdk.utils.Base64Utils;

public enum Pem {

    private static final String BEGIN_MARKER = "-----BEGIN ";

    public static PrivateKey readPrivateKey(InputStream is) throws InvalidKeySpecException, IOException {
        List<PemObject> objects = Pem.readPenObjects(is);
        for (PemObject object : objects) {
            switch (object.getPemObjectType()) {
                case PRIVATE_KEY_PKCS1: {
                    return Rsa.privateKeyFromPkcs1(object.getDerBytes());
                }
                case PRIVATE_KEY_PKCS8: {
                    return Rsa.privateKeyFromPkcs8(object.getDerBytes());
                }
            }
        }
        throw new IllegalArgumentException("Found no private key");
    }

    public static PublicKey readPublicKey(InputStream is) throws InvalidKeySpecException, IOException {
        List<PemObject> objects = Pem.readPenObjects(is);
        for (PemObject object : objects) {
            switch (object.getPemObjectType()) {
                case PUBLIC_KEY_X509: {
                    return Rsa.publicKeyFrom(object.getDerBytes());
                }
            }
        }
        throw new IllegalArgumentException("Found no public key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PemObject> readPenObjects(InputStream is) throws IOException {
        ArrayList<PemObject> pemContents = new ArrayList<PemObject>();
        boolean readingContent = false;
        String beginMarker = null;
        String endMarker = null;
        StringBuffer sb = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (readingContent) {
                    if (line.contains(endMarker)) {
                        pemContents.add(new PemObject(beginMarker, Base64Utils.decode((String)sb.toString())));
                        readingContent = false;
                        continue;
                    }
                    sb.append(line.trim());
                    continue;
                }
                if (!line.contains(BEGIN_MARKER)) continue;
                readingContent = true;
                beginMarker = line.trim();
                endMarker = beginMarker.replace("BEGIN", "END");
                sb = new StringBuffer();
            }
            ArrayList<PemObject> arrayList = pemContents;
            return arrayList;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

