/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.ForwardedValues;
import software.amazon.awssdk.services.cloudfront.transform.CookiePreferenceUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.HeadersUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.QueryStringCacheKeysUnmarshaller;

public class ForwardedValuesUnmarshaller
implements Unmarshaller<ForwardedValues, StaxUnmarshallerContext> {
    private static final ForwardedValuesUnmarshaller INSTANCE = new ForwardedValuesUnmarshaller();

    public ForwardedValues unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ForwardedValues.Builder forwardedValues = ForwardedValues.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("QueryString", targetDepth)) {
                    forwardedValues.queryString(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Cookies", targetDepth)) {
                    forwardedValues.cookies(CookiePreferenceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Headers", targetDepth)) {
                    forwardedValues.headers(HeadersUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("QueryStringCacheKeys", targetDepth)) continue;
                forwardedValues.queryStringCacheKeys(QueryStringCacheKeysUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ForwardedValues)forwardedValues.build();
    }

    public static ForwardedValuesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

