/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.services.cloudfront.model.Paths;
import software.amazon.awssdk.utils.StringInputStream;

public class CreateInvalidationRequestMarshaller
implements Marshaller<Request<CreateInvalidationRequest>, CreateInvalidationRequest> {
    public Request<CreateInvalidationRequest> marshall(CreateInvalidationRequest createInvalidationRequest) {
        if (createInvalidationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createInvalidationRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2017-03-25/distribution/{DistributionId}/invalidation";
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "DistributionId", createInvalidationRequest.distributionId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            InvalidationBatch invalidationBatch = createInvalidationRequest.invalidationBatch();
            if (invalidationBatch != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("InvalidationBatch");
                Paths paths = invalidationBatch.paths();
                if (paths != null) {
                    List<String> pathsItemsList;
                    xmlWriter.startElement("Paths");
                    if (paths.quantity() != null) {
                        xmlWriter.startElement("Quantity").value((Object)paths.quantity()).endElement();
                    }
                    if (!(pathsItemsList = paths.items()).isEmpty() || !(pathsItemsList instanceof SdkAutoConstructList)) {
                        xmlWriter.startElement("Items");
                        for (String pathsItemsListValue : pathsItemsList) {
                            xmlWriter.startElement("Path");
                            xmlWriter.value(pathsItemsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (invalidationBatch.callerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(invalidationBatch.callerReference()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

