/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.CustomHeaders;
import software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig;
import software.amazon.awssdk.services.cloudfront.model.S3OriginConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Origin
implements ToCopyableBuilder<Builder, Origin> {
    private final String id;
    private final String domainName;
    private final String originPath;
    private final CustomHeaders customHeaders;
    private final S3OriginConfig s3OriginConfig;
    private final CustomOriginConfig customOriginConfig;

    private Origin(BuilderImpl builder) {
        this.id = builder.id;
        this.domainName = builder.domainName;
        this.originPath = builder.originPath;
        this.customHeaders = builder.customHeaders;
        this.s3OriginConfig = builder.s3OriginConfig;
        this.customOriginConfig = builder.customOriginConfig;
    }

    public String id() {
        return this.id;
    }

    public String domainName() {
        return this.domainName;
    }

    public String originPath() {
        return this.originPath;
    }

    public CustomHeaders customHeaders() {
        return this.customHeaders;
    }

    public S3OriginConfig s3OriginConfig() {
        return this.s3OriginConfig;
    }

    public CustomOriginConfig customOriginConfig() {
        return this.customOriginConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.customHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OriginConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.customOriginConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.originPath(), other.originPath()) && Objects.equals(this.customHeaders(), other.customHeaders()) && Objects.equals(this.s3OriginConfig(), other.s3OriginConfig()) && Objects.equals(this.customOriginConfig(), other.customOriginConfig());
    }

    public String toString() {
        return ToString.builder((String)"Origin").add("Id", (Object)this.id()).add("DomainName", (Object)this.domainName()).add("OriginPath", (Object)this.originPath()).add("CustomHeaders", (Object)this.customHeaders()).add("S3OriginConfig", (Object)this.s3OriginConfig()).add("CustomOriginConfig", (Object)this.customOriginConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "OriginPath": {
                return Optional.ofNullable(clazz.cast(this.originPath()));
            }
            case "CustomHeaders": {
                return Optional.ofNullable(clazz.cast(this.customHeaders()));
            }
            case "S3OriginConfig": {
                return Optional.ofNullable(clazz.cast(this.s3OriginConfig()));
            }
            case "CustomOriginConfig": {
                return Optional.ofNullable(clazz.cast(this.customOriginConfig()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String domainName;
        private String originPath;
        private CustomHeaders customHeaders;
        private S3OriginConfig s3OriginConfig;
        private CustomOriginConfig customOriginConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Origin model) {
            this.id(model.id);
            this.domainName(model.domainName);
            this.originPath(model.originPath);
            this.customHeaders(model.customHeaders);
            this.s3OriginConfig(model.s3OriginConfig);
            this.customOriginConfig(model.customOriginConfig);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOriginPath() {
            return this.originPath;
        }

        @Override
        public final Builder originPath(String originPath) {
            this.originPath = originPath;
            return this;
        }

        public final void setOriginPath(String originPath) {
            this.originPath = originPath;
        }

        public final CustomHeaders.Builder getCustomHeaders() {
            return this.customHeaders != null ? this.customHeaders.toBuilder() : null;
        }

        @Override
        public final Builder customHeaders(CustomHeaders customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final void setCustomHeaders(CustomHeaders.BuilderImpl customHeaders) {
            this.customHeaders = customHeaders != null ? customHeaders.build() : null;
        }

        public final S3OriginConfig.Builder getS3OriginConfig() {
            return this.s3OriginConfig != null ? this.s3OriginConfig.toBuilder() : null;
        }

        @Override
        public final Builder s3OriginConfig(S3OriginConfig s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig;
            return this;
        }

        public final void setS3OriginConfig(S3OriginConfig.BuilderImpl s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig != null ? s3OriginConfig.build() : null;
        }

        public final CustomOriginConfig.Builder getCustomOriginConfig() {
            return this.customOriginConfig != null ? this.customOriginConfig.toBuilder() : null;
        }

        @Override
        public final Builder customOriginConfig(CustomOriginConfig customOriginConfig) {
            this.customOriginConfig = customOriginConfig;
            return this;
        }

        public final void setCustomOriginConfig(CustomOriginConfig.BuilderImpl customOriginConfig) {
            this.customOriginConfig = customOriginConfig != null ? customOriginConfig.build() : null;
        }

        public Origin build() {
            return new Origin(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Origin> {
        public Builder id(String var1);

        public Builder domainName(String var1);

        public Builder originPath(String var1);

        public Builder customHeaders(CustomHeaders var1);

        default public Builder customHeaders(Consumer<CustomHeaders.Builder> customHeaders) {
            return this.customHeaders((CustomHeaders)((CustomHeaders.Builder)CustomHeaders.builder().applyMutation(customHeaders)).build());
        }

        public Builder s3OriginConfig(S3OriginConfig var1);

        default public Builder s3OriginConfig(Consumer<S3OriginConfig.Builder> s3OriginConfig) {
            return this.s3OriginConfig((S3OriginConfig)((S3OriginConfig.Builder)S3OriginConfig.builder().applyMutation(s3OriginConfig)).build());
        }

        public Builder customOriginConfig(CustomOriginConfig var1);

        default public Builder customOriginConfig(Consumer<CustomOriginConfig.Builder> customOriginConfig) {
            return this.customOriginConfig((CustomOriginConfig)((CustomOriginConfig.Builder)CustomOriginConfig.builder().applyMutation(customOriginConfig)).build());
        }
    }
}

