/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary;

public class ListStreamingDistributionsIterable
implements SdkIterable<ListStreamingDistributionsResponse> {
    private final CloudFrontClient client;
    private final ListStreamingDistributionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamingDistributionsIterable(CloudFrontClient client, ListStreamingDistributionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamingDistributionsResponseFetcher();
    }

    public Iterator<ListStreamingDistributionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<StreamingDistributionSummary> items() {
        Function<ListStreamingDistributionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingDistributionList() != null && response.streamingDistributionList().items() != null) {
                return response.streamingDistributionList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListStreamingDistributionsIterable resume(ListStreamingDistributionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStreamingDistributionsIterable(this.client, (ListStreamingDistributionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.streamingDistributionList().nextMarker()).build()));
        }
        return new ListStreamingDistributionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListStreamingDistributionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListStreamingDistributionsResponseFetcher
    implements SyncPageFetcher<ListStreamingDistributionsResponse> {
        private ListStreamingDistributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingDistributionsResponse previousPage) {
            return previousPage.streamingDistributionList().isTruncated();
        }

        public ListStreamingDistributionsResponse nextPage(ListStreamingDistributionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingDistributionsIterable.this.client.listStreamingDistributions(ListStreamingDistributionsIterable.this.firstRequest);
            }
            return ListStreamingDistributionsIterable.this.client.listStreamingDistributions((ListStreamingDistributionsRequest)((Object)ListStreamingDistributionsIterable.this.firstRequest.toBuilder().marker(previousPage.streamingDistributionList().nextMarker()).build()));
        }
    }
}

