/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LambdaFunctionAssociations
implements ToCopyableBuilder<Builder, LambdaFunctionAssociations> {
    private final Integer quantity;
    private final List<LambdaFunctionAssociation> items;

    private LambdaFunctionAssociations(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<LambdaFunctionAssociation> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociations)) {
            return false;
        }
        LambdaFunctionAssociations other = (LambdaFunctionAssociations)obj;
        return Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"LambdaFunctionAssociations").add("Quantity", (Object)this.quantity()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.of(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<LambdaFunctionAssociation> items;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociations model) {
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<LambdaFunctionAssociation.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(LambdaFunctionAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<LambdaFunctionAssociation> items) {
            this.items = LambdaFunctionAssociationListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(LambdaFunctionAssociation ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<LambdaFunctionAssociation.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (LambdaFunctionAssociation)((LambdaFunctionAssociation.Builder)LambdaFunctionAssociation.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<LambdaFunctionAssociation.BuilderImpl> items) {
            this.items = LambdaFunctionAssociationListCopier.copyFromBuilder(items);
        }

        public LambdaFunctionAssociations build() {
            return new LambdaFunctionAssociations(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LambdaFunctionAssociations> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<LambdaFunctionAssociation> var1);

        public Builder items(LambdaFunctionAssociation ... var1);

        public Builder items(Consumer<LambdaFunctionAssociation.Builder> ... var1);
    }
}

